# Store the current working directory so we can return to it at the end of the script.
working_directory=$(pwd)

if [[ -d /opt/akkadian/aco-server ]]; then
    pip_base="/home/akkadianuser/upgrades/python3.7/pip_packages/"
    rpm_base="/home/akkadianuser/upgrades/mariadb/"
else
    pip_base="/home/akkadianuser/packages/"
    rpm_base=$pip_base
fi


# you need an rpm pip_base and a pip pip_base
if ! rpm -q MariaDB-devel; then
    sudo yum -y install "${rpm_base}MariaDB-devel-10.5.8-1.el7.centos.x86_64.rpm"
fi

if ! rpm -q MariaDB-shared; then
    sudo yum -y install "${rpm_base}MariaDB-shared-10.5.8-1.el7.centos.x86_64.rpm"
fi

function install_local_pip_package() {
    cd $pip_base
    tar -zxvf "$1.tar.gz"
    cd "$1"
    sudo python3 -m pip install --no-index --find-links=./ "$1"
}

if ! python3 -m pip show twisted; then
    install_local_pip_package twisted
fi

if ! python3 -m pip show mariadb; then
    install_local_pip_package mariadb
fi

cd "$working_directory"
