#python_version=$(python -V 2>&1)
#echo "python_version: $python_version" >> /var/www/product_update/update.log

base=/home/akkadianuser
scripts=$base/scripts
productName=$(sh $scripts/universal_updater/get_product_name.sh)

supervisord_file="/usr/bin/supervisord"

if [ "$productName" == 'hcs' ]; then
  python /usr/bin/supervisord -v > ~/supervisordversion
  supervisordVersion=$(cat ~/supervisordversion)
  rm ~/supervisordversion -f
  if  [ "$supervisordVersion"  ==  "3.4.0" ] && [ -s $supervisord_file ]; then
    sh $scripts/supervisor/stopSupervisor.sh
    yum remove supervisor -y
  fi
fi
if [[ ! -f /usr/local/bin/python3.7 ]]; then

    echo "yum install" >> /var/www/product_update/update.log
    package-cleanup -y --cleandupes
    sudo yum -y install gcc openssl-devel bzip2-devel zlib-devel
    sudo yum -y install libffi-devel

    echo "copying packages" >> /var/www/product_update/update.log

    sudo cp -Rf /home/akkadianuser/upgrades/python3.7/Python-3.7.9.tgz /usr/src/
    sudo cp -Rf /home/akkadianuser/upgrades/python3.7/openssl_lib.tar.gz /usr/src/

    echo "changing directories" >> /var/www/product_update/update.log

    cd /usr/src/
    sudo tar xzf Python-3.7.9.tgz
    sudo tar xzf openssl_lib.tar.gz

    if [[ -d /opt/akkadian/aco-server ]]; then
      yes | sudo cp -Rf /home/akkadianuser/upgrades/python3.7/Setup_aco.dist /usr/src/Python-3.7.9/Modules/Setup.dist
    elif [[ -d /var/www/html/pme ]]; then
      yes | sudo cp -Rf /home/akkadianuser/upgrades/python3.7/Setup_apm.dist /usr/src/Python-3.7.9/Modules/Setup.dist
    else
        openssl_path=$(openssl version -a | grep OPENSSLDIR: | awk -F ' ' '{print $2}' | tr -d '"')
        sudo sed -i 's,#SSL=\/usr\/local\/ssl,SSL='"$openssl_path"',g' /home/akkadianuser/upgrades/python3.7/Setup.dist
        yes | sudo cp -Rf /home/akkadianuser/upgrades/python3.7/Setup.dist /usr/src/Python-3.7.9/Modules/Setup.dist
    fi

    echo "Compiling python3.7" >> /var/www/product_update/update.log

    cd Python-3.7.9
    sudo ./configure --enable-optimizations
    sudo make altinstall

    cd /home/akkadianuser
    sudo rm /usr/src/Python-3.7.9.tgz

    sed -i "s/sudo akkadianAppManager menu/sudo \/usr\/local\/bin\/akkadianAppManager menu/g" /home/akkadianuser/.bashrc

    ########################################################################################################################
    ########################################################################################################################
    echo "Upgrade pip" >> /var/www/product_update/update.log
    #upgrade pip
    yes | sudo cp -Rf /home/akkadianuser/upgrades/python3.7/pip_37 /usr/bin/pip3

    sudo ln -s /usr/local/bin/python3.7 /usr/bin/python3

    sudo chmod 755 /usr/bin/pip3

    echo 'PATH="$PATH:/usr/local/bin";export PATH' >> /etc/profile
    . /etc/profile

    if [[ -d /opt/akkadian/aco-server ]]; then
        base=$(echo "/home/akkadianuser/upgrades/python3.7/pip_packages/")
    else
        base=$(echo "/var/www/product_update/scripts/")
    fi

    mv /home/akkadianuser/packages/pip.tar.gz "${base}pip.tar.gz"
    cd "$base"
    tar -zxvf pip.tar.gz
    cd pip
    sudo pip3 install --upgrade pip-21.1.2-py3-none-any.whl -f ./ --no-index --no-deps

    mv /home/akkadianuser/packages/click.tar.gz "${base}click.tar.gz"
    cd "$base"
    tar -zxvf click.tar.gz
    cd click
    sudo pip3 install Click-7.0-py2.py3-none-any.whl -f ./ --no-index --no-deps

    mv /home/akkadianuser/packages/netifaces.tar.gz "${base}netifaces.tar.gz"
    cd "$base"
    tar -zxvf netifaces.tar.gz
    cd netifaces
    sudo pip3 install netifaces-0.11.0-cp37-cp37m-manylinux_2_5_x86_64.manylinux1_x86_64.whl -f ./ --no-index --no-deps


    cd /home/akkadianuser

    echo "making app manager available in centos" >> /var/www/product_update/update.log

    #check where the installation takes replace
    sudo rm -Rf /bin/akkadianAppManager

    sudo python3 setup.py install
    date=$(date)
    echo "python37, $date, installed python 3.7, true" >> /home/akkadianuser/upgrades/migration_history.csv

    sleep 3
else
    # If the first version where python points to python3.7 was installed
    # if we are in version 4.0: python -> python3.7, python2.7
    # what we want is: python -> python2.7 and python3
    python_version=$(python --version)
    if [[ "$python_version" == "Python 3.7.9" ]]; then

        sudo ln -s /usr/local/bin/python3.7 /usr/bin/python3
        sudo rm -Rf /usr/bin/python
        sudo ln -s /usr/bin/python2.7 /usr/bin/python

        sudo cp -Rf /usr/bin/pip /usr/bin/pip3
        sudo chmod 755 /usr/bin/pip3
        sed -i 's,#!/usr/bin/python,#!/usr/bin/python3,g' /usr/bin/pip3
        sudo cp -Rf /usr/bin/pip2.7 /usr/bin/pip

        echo 'PATH="$PATH:/usr/local/bin";export PATH' >> /etc/profile
        . /etc/profile
        sed -i "s/sudo akkadianAppManager menu/sudo \/usr\/local\/bin\/akkadianAppManager menu/g" /home/akkadianuser/.bashrc

    # This is the case were we are here from acm version 3.4, where python3 is installed but we need to install cli new version
    elif [[ "$productName" == 'acm' ]]; then

        echo 'PATH="$PATH:/usr/local/bin";export PATH' >> /etc/profile
        . /etc/profile
        sed -i "s/sudo akkadianAppManager menu/sudo \/usr\/local\/bin\/akkadianAppManager menu/g" /home/akkadianuser/.bashrc

        # Installing libraries:
        if [[ -d /opt/akkadian/aco-server ]]; then
            base=$(echo "/home/akkadianuser/upgrades/python3.7/pip_packages/")
        else
            base=$(echo "/var/www/product_update/scripts/")
        fi

        cd $base
        tar -zxvf pip.tar.gz
        cd pip
        sudo pip3 install --upgrade pip-21.1.2-py3-none-any.whl -f ./ --no-index --no-deps

        cd $base
        tar -zxvf click.tar.gz
        cd click
        sudo pip3 install Click-7.0-py2.py3-none-any.whl -f ./ --no-index --no-deps

        cd $base
        tar -zxvf netifaces.tar.gz
        cd netifaces
        sudo pip3 install netifaces-0.11.0-cp37-cp37m-manylinux_2_5_x86_64.manylinux1_x86_64.whl -f ./ --no-index --no-deps

        echo "making app manager available in centos" >> /var/www/product_update/update.log
        sudo rm -Rf /bin/akkadianAppManager

        sudo python3 setup.py install
        #check where the installation takes replace
        date=$(date)
        echo "python37, $date, installed python 3.7, true" >> /home/akkadianuser/upgrades/migration_history.csv

        sleep 3
    fi

fi
