#!/usr/bin/env bash
base=$(echo "https://centosrepo.akkadianlabs.com/mariadb/")
mariadb_version=$(/bin/mysql --version | /bin/awk '{ print $5 }' | /bin/awk -F\, '{ print $1 }')
echo "mariadb_version: $mariadb_version" >>/var/www/product_update/update.log

function event_scheduler_error_exists() {
    disabled_event_count="$(mysql --defaults-extra-file=/home/akkadianuser/.my.cnf -e "SELECT count(e.EVENT_NAME) FROM information_schema.EVENTS as e WHERE e.STATUS != 'ENABLED';" 2>&1)"
    if echo "$disabled_event_count" | grep -q "ERROR" &&
        echo "$disabled_event_count" | grep -q "event scheduler is disabled"; then
        echo 'true'
    else
        echo 'false'
    fi
}

function run_mysql_upgrade() {
    sudo mysql_upgrade --defaults-extra-file=/home/akkadianuser/.my.cnf -u root

    if [[ $(event_scheduler_error_exists) == 'true' ]]; then
        sudo mysql_upgrade --defaults-extra-file=/home/akkadianuser/.my.cnf -u root

        if [[ $(event_scheduler_error_exists) == 'true' ]]; then
            sudo mysql_upgrade --defaults-extra-file=/home/akkadianuser/.my.cnf -u root --force
        fi
    fi
}

if [[ $mariadb_version != "10.5.8-MariaDB" ]]; then
    echo "Trying to install new mariadb version " >>/var/www/product_update/update.log
    server=$(echo $base"MariaDB-server-10.5.8-1.el7.centos.x86_64.rpm")
    echo "$server" >>/var/www/product_update/update.log

    #    These packages get downloaded in the pre_install_validation_checks.sh script. They are downloaded to
    #    the /var/www/product_update/scripts folder.

    #    curl -k $base"MariaDB-server-10.5.8-1.el7.centos.x86_64.rpm" --output MariaDB-server-10.5.8-1.el7.centos.x86_64.rpm
    #    curl -k $base"galera-4-26.4.6-1.el7.centos.x86_64.rpm" --output galera-4-26.4.6-1.el7.centos.x86_64.rpm
    #    curl -k $base"MariaDB-client-10.5.8-1.el7.centos.x86_64.rpm" --output MariaDB-client-10.5.8-1.el7.centos.x86_64.rpm
    #    curl -k $base"MariaDB-shared-10.5.8-1.el7.centos.x86_64.rpm" --output MariaDB-shared-10.5.8-1.el7.centos.x86_64.rpm
    #    curl -k $base"MariaDB-backup-10.5.8-1.el7.centos.x86_64.rpm" --output MariaDB-backup-10.5.8-1.el7.centos.x86_64.rpm
    #    curl -k $base"MariaDB-common-10.5.8-1.el7.centos.x86_64.rpm" --output MariaDB-common-10.5.8-1.el7.centos.x86_64.rpm

    #sudo sed -i 's/10.2/10.4/' /etc/yum.repos.d/MariaDB.repo
    #sudo rpm --import https://yum.mariadb.org/RPM-GPG-KEY-MariaDB
    systemctl stop mariadb
    sudo yum -y remove MariaDB-server
    sleep 3
    echo "sleeping" >>/var/www/product_update/update.log
    sudo yum -y install MariaDB-server-10.5.8-1.el7.centos.x86_64.rpm galera-4-26.4.6-1.el7.centos.x86_64.rpm MariaDB-client-10.5.8-1.el7.centos.x86_64.rpm MariaDB-shared-10.5.8-1.el7.centos.x86_64.rpm MariaDB-backup-10.5.8-1.el7.centos.x86_64.rpm MariaDB-common-10.5.8-1.el7.centos.x86_64.rpm

    sudo systemctl enable mariadb
    sudo systemctl start mariadb

    run_mysql_upgrade

    sudo systemctl restart mariadb

    sudo firewall-cmd --permanent --add-port=3306/tcp
    sudo firewall-cmd --permanent --add-port=4567/tcp
    sudo firewall-cmd --permanent --add-port=4568/tcp
    sudo firewall-cmd --permanent --add-port=4444/tcp
    sudo firewall-cmd --reload

    sudo rm -Rf MariaDB-server-10.5.8-1.el7.centos.x86_64.rpm galera-4-26.4.6-1.el7.centos.x86_64.rpm MariaDB-client-10.5.8-1.el7.centos.x86_64.rpm MariaDB-shared-10.5.8-1.el7.centos.x86_64.rpm MariaDB-backup-10.5.8-1.el7.centos.x86_64.rpm MariaDB-common-10.5.8-1.el7.centos.x86_64.rpm

    # This is to install devel and shared needed for pip to install mariadb connector for python
    # TODO: fix this!!!
    # curl -sS https://downloads.mariadb.com/MariaDB/mariadb_repo_setup | sudo bash
    # sudo yum -y install MariaDB-devel
    # sudo yum -y install MariaDB-shared

    # cd /home/akkadianuser
    # pip install mariadb
else
    run_mysql_upgrade
fi
