#!/usr/bin/env bash

LGREEN='\033[1;32m'
NC='\033[0m' # No Color

base=/home/akkadianuser
scripts=$base/scripts

if [ "$(systemctl status supervisord | grep "active" | awk '{print $2}')" == 'active' ]; then
    echo -e "${LGREEN}Stopping supervisor service${NC}"
    sh $scripts/supervisor/stopSupervisor.sh
fi

echo -e "${LGREEN}Installing supervisor via pip${NC}"
echo "Installing supervisor via pip" >>/var/www/product_update/update.log
# pip install supervisor
mv /home/akkadianuser/packages/supervisor.tar.gz /var/www/product_update/scripts/supervisor.tar.gz
cd /var/www/product_update/scripts
tar -zxvf supervisor.tar.gz
cd supervisor
sudo /usr/local/bin/pip3 install supervisor-4.2.2-py2.py3-none-any.whl -f ./ --no-index --no-deps

echo "Creating supervisor directory for ini files" >>/var/www/product_update/update.log
if [ ! -d /etc/supervisord.d ]; then
    mkdir /etc/supervisord.d
fi

echo -e "${LGREEN}Copying supervisord service to proper path${NC}"
echo "Copying supervisord service to proper path" >>/var/www/product_update/update.log
cp $scripts/supervisor/supervisord.service /etc/systemd/system/supervisord.service

echo "Creating directory for supervisor log file" >>/var/www/product_update/update.log
if [ ! -d /var/log/supervisor/ ]; then
    mkdir /var/log/supervisor
fi

echo -e "${LGREEN}Copying supervisord config file to proper path${NC}"
echo "Copying supervisord config file to proper path" >>/var/www/product_update/update.log
cp $scripts/supervisor/supervisord.conf /etc/supervisord.conf

echo -e "${LGREEN}Creating symlinks for supervisord and supervisorctl${NC}"
echo "Creating symlinks for supervisord and supervisorctl" >>/var/www/product_update/update.log
ln -s /usr/local/bin/supervisord /usr/bin/supervisord
ln -s /usr/local/bin/supervisorctl /usr/bin/supervisorctl

echo -e "${LGREEN}Reloading systemctl daemon${NC}"
echo "Reloading systemctl daemon" >>/var/www/product_update/update.log
systemctl daemon-reload

supervisord_file="/usr/bin/supervisord"

if [ -s $supervisord_file ] && [ ! -s /etc/supervisord.d/asb-queue-work.conf ]; then
    echo -e "${LGREEN}Copying ASB queue worker configuration file${NC}"

    cp $scripts/supervisor/asb_config_files/asb_worker.ini /etc/supervisord.d/asb-queue-work.conf

    echo -e "${LGREEN}Files have been copied...${NC}"
    echo "Files have been copied" >>/var/www/product_update/update.log
fi

echo -e "${LGREEN}Enabling supervisord${NC}"
sh $scripts/supervisor/enableSupervisor.sh

echo -e "${LGREEN}Starting supervisord${NC}"
sh $scripts/supervisor/startSupervisor.sh
