#!/usr/bin/env bash

LGREEN='\033[1;32m'
NC='\033[0m' # No Color

base=/home/akkadianuser
scripts=$base/scripts
productName=$(sh $scripts/universal_updater/get_product_name.sh)

supervisord_file="/usr/bin/supervisord"
beanstalkd_file="/usr/bin/beanstalkd"

if [ -s $beanstalkd_file ] && [ -s $supervisord_file ]; then
    echo -e "${LGREEN}Copying Bulk/Realtime Worker Manager config file for Non-HA${NC}"
    echo "Copying Bulk/Realtime conf to supervisord config file for HA" >>/var/www/product_update/update.log
    cp $scripts/supervisor/apm_config_files/apm_bulk_worker_manager_non_ha.ini /etc/supervisord.d/apm_bulk_worker_manager.ini
    cp $scripts/supervisor/apm_config_files/apm_realtime_worker_manager_non_ha.ini /etc/supervisord.d/apm_realtime_worker_manager.ini

    if [ "$productName" == 'hcs' ]; then
        rm -f /etc/supervisord.d/asb-queue-work.conf
        cp $scripts/supervisor/asb_config_files/asb_worker.ini /etc/supervisord.d/asb-queue-work.ini
        cp $scripts/supervisor/apm_config_files/apm_hcs_queue_work.ini /etc/supervisord.d/apm_hcs_queue_work.ini
    fi

    echo -e "${LGREEN}Files have been copied...${NC}"
    echo "Files have been copied" >>/var/www/product_update/update.log
fi