#!/usr/bin/env bash

BASE="/home/akkadianuser/packages/"
VERSION="1.0.4"
RELEASE="2.1"

RPM_FILENAME="AkkadianCDRCollector-"$VERSION"-"$RELEASE".noarch.rpm"
RPM_PATH=$BASE"$RPM_FILENAME"

if [[ -f $RPM_PATH && -s $RPM_PATH ]]; then
    # run install but suppress output
    sudo yum -y install $RPM_PATH &> /dev/null
fi

if (($? == 0)); then
    echo "Successfully installed Akkadian CDR Collector Version: ${VERSION}-${RELEASE}" >>/var/www/product_update/update.log
elif (($? == 1)); then

    # run install again and see if it's caused by nothing to do error.
    sudo yum -y install $RPM_PATH 2>&1 | tee /tmp/cdr_install_log &>/dev/null #install and send output to tmp file. ignore output from tee
    grep -q "Error: Nothing to do" /tmp/cdr_install_log

    if (($? == 0)); then #same version installed. Process as success
        echo "Skipping installation of Akkadian CDR Collector Version: ${VERSION}-${RELEASE}, Same or newer version installed." >>/var/www/product_update/update.log
    else
        echo "Installation failed for Akkadian CDR Collector Version: ${VERSION}-${RELEASE}" >>/var/www/product_update/update.log
    fi

else
    echo "Installation failed for Akkadian CDR Collector Version: ${VERSION}-${RELEASE}" >>/var/www/product_update/update.log
fi
