#!/usr/bin/env bash
# This is a script that runs in jenkins to generate the needed universal_updater package

path_to_product=""
include_cli=""
path_to_cli_with_auu=""
include_product=""
product=""
version=""
build=""
encrypt=""

for ARGUMENT in "$@"; do
    KEY=$(echo $ARGUMENT | cut -f1 -d=)
    VALUE=$(echo $ARGUMENT | cut -f2 -d=)
    case "$KEY" in
    --path_to_product) path_to_product=${VALUE} ;;
    --include_cli) include_cli=${VALUE} ;;
    --path_to_cli_with_auu) path_to_cli_with_auu=${VALUE} ;;
    --include_product) include_product=${VALUE} ;;
    --product) product=${VALUE} ;;
    --version) version=${VALUE} ;;
    --build) build=${VALUE} ;;
    --encrypt) encrypt=${VALUE} ;;
    --dev) dev=${VALUE} ;;
    *) ;;
    esac
done

sudo rm -Rf ./*.zip
sudo rm -Rf tmp

mkdir tmp
mkdir tmp/universal_updater_package
mkdir tmp/universal_updater_package/scripts
mkdir tmp/universal_updater_package/packages
mkdir tmp/universal_updater_package/updates

# preparing the scripts
cp -Rf universal_installer_scripts/pre-scripts/* tmp/universal_updater_package/scripts/
cp -Rf universal_installer_scripts/post-scripts/* tmp/universal_updater_package/scripts/
cp -Rf universal_installer_scripts/rollback/* tmp/universal_updater_package/scripts/

IFS=','
echo "These are the pre scripts"

pre_scripts_folder=universal_installer_scripts/pre-scripts
if [ "$(ls -A $pre_scripts_folder)" ]; then
    prescriptslist="["
    for filename in $pre_scripts_folder; do
        only_name=$(basename $filename)
        prescriptslist=$(echo "$prescriptslist\"$only_name\",")
    done
    prescriptslist=${prescriptslist::-1}
    prescriptslist=$(echo "$prescriptslist]")
    echo "This is the variable into the manifest.json: $prescriptslist"
else
    prescriptslist="[]"
fi

post_scripts_folder=universal_installer_scripts/post-scripts
if [ "$(ls -A $post_scripts_folder)" ]; then
    postscriptslist="["
    for filename in $post_scripts_folder; do
        only_name=$(basename $filename)
        postscriptslist=$(echo "$postscriptslist\"$only_name\",")
    done
    postscriptslist=${postscriptslist::-1}
    postscriptslist=$(echo "$postscriptslist]")
    echo "This is the variable into the manifest.json: $postscriptslist"
else
    postscriptslist="[]"
fi

rollback_folder="universal_installer_scripts/rollback/*"
if [ "$(ls -A $rollback_folder)" ]; then
    rollbacklist="["
    for filename in $rollback_folder; do
        only_name=$(basename $filename)
        rollbacklist=$(echo "$rollbacklist\"$only_name\",")
    done
    rollbacklist=${rollbacklist::-1}
    rollbacklist=$(echo "$rollbacklist]")
    echo "This is the variable into the manifest.json: $rollbacklist"
else
    rollbacklist="[]"
fi

package_folder=universal_installer_scripts/packages
if [ "$(ls -A $package_folder)" ]; then
    packageslist="["
    for filename in $package_folder; do
        only_name=$(basename $filename)
        packageslist=$(echo "$packageslist\"$only_name\",")
    done
    packageslist=${packageslist::-1}
    packageslist=$(echo "$packageslist]")
    echo "This is the variable into the manifest.json: $packageslist"
else
    packageslist="[]"
fi

#this has to be the full url
if [[ $include_cli == "yes" ]]; then
    echo "CLI to include: $path_to_cli_with_auu"
    wget -P tmp/universal_updater_package/updates "$path_to_cli_with_auu"

    cli_package_name=$(sudo ls -1 tmp/universal_updater_package/updates/*.tar.gz 2> /dev/null | tail -1)
    cli_package_name=$(basename $cli_package_name)
    cli_update_command=$(echo "update_cli.sh $cli_package_name")
fi

sleep 5
yum -y install jq
sleep 5

if [[ $include_product == "yes" ]]; then
    echo "Product to include: $path_to_product"
    wget -P tmp/universal_updater_package/updates/ "$path_to_product"

    product_package_name=$(basename $path_to_product)
    update_product_command=$(echo "update_product.sh -$product $product_package_name")
fi

echo "pre-scripts: $prescriptslist"
echo "post-scripts: $postscriptslist"
echo "rollback: $rollbacklist"
echo "packages: $packageslist"

# Overwritting this because new approach:
prescriptslist=$(echo "[\"pre-script_main.sh\"]")
postscriptslist=$(echo "[\"post-script_main.sh\"]")
rollbacklist=$(echo "[\"rollback_main.sh\"]")
# TODO: package list builder loop needs to be fixed
packageslist="[]"

jq -n --arg product "$product" --arg version "$version" --arg build "$build" --arg product_file "$product_package_name" --arg cli_package_name "$cli_package_name" --argjson packages "$packageslist" --argjson prescripts "$prescriptslist" --argjson postscripts "$postscriptslist" --argjson rollback "$rollbacklist" --arg cli_update_command "$cli_update_command" --arg update_product_command "$update_product_command" '{
      "product":
      {
        "product_name":$product,
        "version": $version,
        "build": $build
      },
      "files": {
        "product_file_name": $product_file,
        "cli_file_name": $cli_package_name
      },
      "packages": $packages,
      "prescripts": $prescripts,
      "cli_update_command": $cli_update_command,
      "product_update_command": $update_product_command,
      "postscripts": $postscripts,
      "rollback": $rollback

  }' > tmp/universal_updater_package/manifest.json

rm -Rf tmp/*.zip

#Building the name of the package ###################################
productfilename=$(basename -- "$product_package_name")
productfilename="${productfilename%.*}"

#Remove gz
clifilename=$(basename -- "$cli_package_name")
clifilename="${clifilename%.*}"

#Remove tar
clifilename=$(basename -- "$clifilename")
clifilename="${clifilename%.*}"

if [[ $productfilename == *"Update"* ]]; then
    productfilename=$(printf '%s\n' "${productfilename//-Update/}")
fi

if [[ $clifilename != "" ]]; then
    uu_name=$(echo "Akkadian_Update_${productfilename}_${clifilename}")
else
    uu_name=$(echo "Akkadian_Update_${productfilename}")
fi

# Replace two or more underscores with a single underscore.
uu_name=$(echo $uu_name | sed -r "s/__+/_/")

cd tmp/universal_updater_package || exit 1

if [[ $encrypt == "yes" ]]; then
    echo "encrypting and zipping..."
    zip -r ${uu_name}.zip .
    sleep 15
    #this line stop working: openssl enc -e -aes-256-cbc -in ${uu_name}.zip -out ${uu_name}-en.zip -pass pass:'HtBr6QckqJPk4rpatyUNT594'
    openssl aes-256-cbc -salt -a -e -md sha256 -in ${uu_name}.zip -out ${uu_name}-en.zip -pass pass:'HtBr6QckqJPk4rpatyUNT594'
    sleep 10
    rm -Rf ${uu_name}.zip
    echo "ended encrypting and zipping"
else
    echo "zipping..."
    zip -r ${uu_name}.zip .
fi
cd ../..
####################################################################

rm -Rf scripts
rm -Rf packages
rm -Rf updates
rm -Rf manifest.json

if [[ ! -d /var/www/html/ova/universal_updater/ ]]; then
    mkdir /var/www/html/ova/universal_updater/
fi

if [[ $dev == "yes" ]]; then
    cp -Rf tmp/universal_updater_package/*.zip /var/www/html/ova/universal_updater/apm-dev/
else
    cp -Rf tmp/universal_updater_package/*.zip /var/www/html/ova/universal_updater/
fi
