<?php

$currentCliVersion = $argv[1];
$minimumCliVersion = $argv[2];
$operator = isset($argv[3]) ? $argv[3] : null;

function formatString($version)
{
    $leftPadLength = 10;
    $rightPadLength = 50;
    $preparedVersion = explode('-', $version)[0];

    $versionComparisonString = implode('', array_map(function ($piece) use ($leftPadLength) {
        return str_pad($piece, $leftPadLength, '0', STR_PAD_LEFT);
    }, explode('.', $preparedVersion)));

    return str_pad($versionComparisonString, $rightPadLength, '0', STR_PAD_RIGHT);
}

$currentCliVersion = formatString($currentCliVersion);
$minimumCliVersion = formatString($minimumCliVersion);

switch ($operator) {
    case 'lt':
        echo $currentCliVersion < $minimumCliVersion ? 'True' : 'False';
        break;
    case 'eq':
        echo $currentCliVersion === $minimumCliVersion ? 'True' : 'False';
        break;
    case 'gt':
        echo $currentCliVersion > $minimumCliVersion ? 'True' : 'False';
        break;
    // The default case preserves the original behavior of this script since some places are calling it without a third
    // argument.
    default:
        echo $currentCliVersion >= $minimumCliVersion ? 'True' : 'False';
}
