#!/usr/bin/env bash

#remove mech list from sasl2 slapd.conf
cat >/etc/sasl2/slapd.conf <<EOF
pwcheck_method: saslauthd
saslauthd_path: /var/run/saslauthd/mux
EOF

# stop openldap service and remove openldap files
systemctl stop slapd

# start openldap service
systemctl start slapd

# create ldif to modify olcSizeLimit value
cat >addCustomAttributes.ldif <<EOF
dn: cn={4}directoryobject,cn=schema,cn=config
changetype: modify
add: olcAttributeTypes
olcAttributeTypes: ( 1.2.3.4.5.6.9
  NAME 'customAttribute1'
  SYNTAX 1.3.6.1.4.1.1466.115.121.1.15
  EQUALITY caseIgnoreMatch
  SUBSTR caseIgnoreSubstringsMatch
  SINGLE-VALUE )
olcAttributeTypes: ( 1.2.3.4.5.6.10
  NAME 'customAttribute2'
  SYNTAX 1.3.6.1.4.1.1466.115.121.1.15
  EQUALITY caseIgnoreMatch
  SUBSTR caseIgnoreSubstringsMatch
  SINGLE-VALUE )
olcAttributeTypes: ( 1.2.3.4.5.6.11
  NAME 'customAttribute3'
  SYNTAX 1.3.6.1.4.1.1466.115.121.1.15
  EQUALITY caseIgnoreMatch
  SUBSTR caseIgnoreSubstringsMatch
  SINGLE-VALUE )
olcAttributeTypes: ( 1.2.3.4.5.6.12
  NAME 'customAttribute4'
  SYNTAX 1.3.6.1.4.1.1466.115.121.1.15
  EQUALITY caseIgnoreMatch
  SUBSTR caseIgnoreSubstringsMatch
  SINGLE-VALUE )
olcAttributeTypes: ( 1.2.3.4.5.6.13
  NAME 'customAttribute5'
  SYNTAX 1.3.6.1.4.1.1466.115.121.1.15
  EQUALITY caseIgnoreMatch
  SUBSTR caseIgnoreSubstringsMatch
  SINGLE-VALUE )
olcAttributeTypes: ( 1.2.3.4.5.6.14
  NAME 'customAttribute6'
  SYNTAX 1.3.6.1.4.1.1466.115.121.1.15
  EQUALITY caseIgnoreMatch
  SUBSTR caseIgnoreSubstringsMatch
  SINGLE-VALUE )
olcAttributeTypes: ( 1.2.3.4.5.6.15
  NAME 'customAttribute7'
  SYNTAX 1.3.6.1.4.1.1466.115.121.1.15
  EQUALITY caseIgnoreMatch
  SUBSTR caseIgnoreSubstringsMatch
  SINGLE-VALUE )
olcAttributeTypes: ( 1.2.3.4.5.6.16
  NAME 'customAttribute8'
  SYNTAX 1.3.6.1.4.1.1466.115.121.1.15
  EQUALITY caseIgnoreMatch
  SUBSTR caseIgnoreSubstringsMatch
  SINGLE-VALUE )
olcAttributeTypes: ( 1.2.3.4.5.6.17
  NAME 'customAttribute9'
  SYNTAX 1.3.6.1.4.1.1466.115.121.1.15
  EQUALITY caseIgnoreMatch
  SUBSTR caseIgnoreSubstringsMatch
  SINGLE-VALUE )
olcAttributeTypes: ( 1.2.3.4.5.6.18
  NAME 'customAttribute10'
  SYNTAX 1.3.6.1.4.1.1466.115.121.1.15
  EQUALITY caseIgnoreMatch
  SUBSTR caseIgnoreSubstringsMatch
  SINGLE-VALUE )
olcAttributeTypes: ( 1.2.3.4.5.6.19
  NAME 'localData1'
  SYNTAX 1.3.6.1.4.1.1466.115.121.1.15
  EQUALITY caseIgnoreMatch
  SUBSTR caseIgnoreSubstringsMatch
  SINGLE-VALUE )
olcAttributeTypes: ( 1.2.3.4.5.6.20
  NAME 'localData2'
  SYNTAX 1.3.6.1.4.1.1466.115.121.1.15
  EQUALITY caseIgnoreMatch
  SUBSTR caseIgnoreSubstringsMatch
  SINGLE-VALUE )
olcAttributeTypes: ( 1.2.3.4.5.6.21
  NAME 'localData3'
  SYNTAX 1.3.6.1.4.1.1466.115.121.1.15
  EQUALITY caseIgnoreMatch
  SUBSTR caseIgnoreSubstringsMatch
  SINGLE-VALUE )
olcAttributeTypes: ( 1.2.3.4.5.6.22
  NAME 'localData4'
  SYNTAX 1.3.6.1.4.1.1466.115.121.1.15
  EQUALITY caseIgnoreMatch
  SUBSTR caseIgnoreSubstringsMatch
  SINGLE-VALUE )
olcAttributeTypes: ( 1.2.3.4.5.6.23
  NAME 'localData5'
  SYNTAX 1.3.6.1.4.1.1466.115.121.1.15
  EQUALITY caseIgnoreMatch
  SUBSTR caseIgnoreSubstringsMatch
  SINGLE-VALUE )
olcAttributeTypes: ( 1.2.3.4.5.6.24
  NAME 'localData6'
  SYNTAX 1.3.6.1.4.1.1466.115.121.1.15
  EQUALITY caseIgnoreMatch
  SUBSTR caseIgnoreSubstringsMatch
  SINGLE-VALUE )
olcAttributeTypes: ( 1.2.3.4.5.6.25
  NAME 'localData7'
  SYNTAX 1.3.6.1.4.1.1466.115.121.1.15
  EQUALITY caseIgnoreMatch
  SUBSTR caseIgnoreSubstringsMatch
  SINGLE-VALUE )
olcAttributeTypes: ( 1.2.3.4.5.6.26
  NAME 'localData8'
  SYNTAX 1.3.6.1.4.1.1466.115.121.1.15
  EQUALITY caseIgnoreMatch
  SUBSTR caseIgnoreSubstringsMatch
  SINGLE-VALUE )
olcAttributeTypes: ( 1.2.3.4.5.6.27
  NAME 'localData9'
  SYNTAX 1.3.6.1.4.1.1466.115.121.1.15
  EQUALITY caseIgnoreMatch
  SUBSTR caseIgnoreSubstringsMatch
  SINGLE-VALUE )
olcAttributeTypes: ( 1.2.3.4.5.6.28
  NAME 'localData10'
  SYNTAX 1.3.6.1.4.1.1466.115.121.1.15
  EQUALITY caseIgnoreMatch
  SUBSTR caseIgnoreSubstringsMatch
  SINGLE-VALUE )
-
delete: olcObjectClasses
olcObjectClasses: {0}( 1.2.3.4.5.6.8
  NAME 'directoryObject'
  DESC 'Directory entry item'
  SUP inetOrgPerson
  STRUCTURAL
  MAY ( sAMAccountName ) )
-
add: olcObjectClasses
olcObjectClasses: {0}( 1.2.3.4.5.6.8
  NAME 'directoryObject'
  DESC 'Directory entry item'
  SUP inetOrgPerson
  STRUCTURAL
  MAY ( sAMAccountName $ customAttribute1 $ customAttribute2 $ customAttribute3 $ customAttribute4 $ customAttribute5 $ customAttribute6 $ customAttribute7 $ customAttribute8 $ customAttribute9 $ customAttribute10 $ localData1 $ localData2 $ localData3 $ localData4 $ localData5 $ localData6 $ localData7 $ localData8 $ localData9 $ localData10 ) )
EOF

#run ldapmodify
ldapadd -Y EXTERNAL -H ldapi:/// -f addCustomAttributes.ldif
rm -rf addCustomAttributes.ldif

#update openldap structure with guid
cat >addCustomAttributes.ldif <<EOF
dn: cn={4}directoryobject,cn=schema,cn=config
changetype: modify
add: olcAttributeTypes
olcAttributeTypes: ( 1.2.3.4.5.6.29
  NAME 'guid'
  SYNTAX 1.3.6.1.4.1.1466.115.121.1.15
  EQUALITY caseIgnoreMatch
  SUBSTR caseIgnoreSubstringsMatch
  SINGLE-VALUE )
-
delete: olcObjectClasses
olcObjectClasses: {0}( 1.2.3.4.5.6.8
  NAME 'directoryObject'
  DESC 'Directory entry item'
  SUP inetOrgPerson
  STRUCTURAL
  MAY ( sAMAccountName $ customAttribute1 $ customAttribute2 $ customAttribute3 $ customAttribute4 $ customAttribute5 $ customAttribute6 $ customAttribute7 $ customAttribute8 $ customAttribute9 $ customAttribute10 $ localData1 $ localData2 $ localData3 $ localData4 $ localData5 $ localData6 $ localData7 $ localData8 $ localData9 $ localData10 ) )
-
add: olcObjectClasses
olcObjectClasses: {0}( 1.2.3.4.5.6.8
  NAME 'directoryObject'
  DESC 'Directory entry item'
  SUP inetOrgPerson
  STRUCTURAL
  MAY ( sAMAccountName $ customAttribute1 $ customAttribute2 $ customAttribute3 $ customAttribute4 $ customAttribute5 $ customAttribute6 $ customAttribute7 $ customAttribute8 $ customAttribute9 $ customAttribute10 $ localData1 $ localData2 $ localData3 $ localData4 $ localData5 $ localData6 $ localData7 $ localData8 $ localData9 $ localData10 $ guid ) )
EOF

#run ldapmodify
ldapadd -Y EXTERNAL -H ldapi:/// -f addCustomAttributes.ldif
rm -rf addCustomAttributes.ldif

#add mech_list back into slapd.conf
cat >/etc/sasl2/slapd.conf <<EOF
pwcheck_method: saslauthd
mech_list: plain
saslauthd_path: /var/run/saslauthd/mux
EOF

# stop openldap service and remove openldap files
systemctl stop slapd

# start openldap service
systemctl start slapd
