# Checks if installation product and installed product match. If not, exits with 1.
file="/var/www/product_update/manifest.json"
installed_product_name=$(sudo sh /home/akkadianuser/scripts/universal_updater/get_product_name.sh)
update_product_name=$(jq -r '.product.product_name' $file)

if [[ "$update_product_name" != "cli" ]]; then
    if [[ "$installed_product_name" == "apm" && "$update_product_name" != "apm" ]]; then
        echo "APM update failed due to an attempt to apply a non-enterprise update to an enterprise APM system." >>/var/www/product_update/update.log
        echo "500 - Error: Update failed due to an attempt to apply a non-enterprise APM update to an enterprise APM system." >/var/www/product_update/installation.progress
        sleep 5
        exit 1
    fi

    if [[ "$installed_product_name" == "hcs" && "$update_product_name" != "hcs" ]]; then
        echo "APM update failed due to an attempt to apply a non-HCS update to an HCS APM system." >>/var/www/product_update/update.log
        echo "500 - Error: Update failed due to an attempt to apply a non-HCS update to an HCS APM system." >/var/www/product_update/installation.progress
        sleep 5
        exit 1
    fi
fi

exit 0

