#!/usr/bin/env bash


#remove mech list from sasl2 slapd.conf
cat > /etc/sasl2/slapd.conf <<EOF
pwcheck_method: saslauthd
saslauthd_path: /var/run/saslauthd/mux
EOF

# stop openldap service and remove openldap files
systemctl stop slapd

# start openldap service
systemctl start slapd

# create ldif to modify olcSizeLimit value
cat > addCustomAttribute.ldif <<EOF
dn: cn=directoryobject,cn=schema,cn=config
objectClass: olcSchemaConfig
cn: directoryobject
olcAttributetypes: ( 1.2.3.4.5.6.7
  NAME 'sAMAccountName'
  SYNTAX 1.3.6.1.4.1.1466.115.121.1.15
  EQUALITY caseIgnoreMatch
  SUBSTR caseIgnoreSubstringsMatch
  SINGLE-VALUE )
olcObjectClasses: ( 1.2.3.4.5.6.8
  NAME 'directoryObject'
  DESC 'Directory entry item'
  SUP inetOrgPerson
  STRUCTURAL
  MAY ( sAMAccountName ) )
EOF

#run ldapmodify
ldapadd -Y EXTERNAL -H ldapi:/// -f addCustomAttribute.ldif
rm -rf addCustomAttribute.ldif

#add mech_list back into slapd.conf
cat > /etc/sasl2/slapd.conf <<EOF
pwcheck_method: saslauthd
mech_list: plain
saslauthd_path: /var/run/saslauthd/mux
EOF

# stop openldap service and remove openldap files
systemctl stop slapd

# start openldap service
systemctl start slapd