#!/usr/bin/env bash

log=/var/www/product_update/update.log

echo "$(date --rfc-3339=seconds) Checking if OpenSSL is version 1.1.1." >>$log
if ! /usr/bin/openssl version | grep -q 1.1.1; then
    echo "$(date --rfc-3339=seconds) OpenSSL is not 1.1.1. It is $(sudo /usr/bin/openssl version)." >>$log
    if [[ -s /usr/local/openssl/bin/openssl ]]; then
        if /usr/local/openssl/bin/openssl version | grep -q 1.1.1; then
            echo "$(date --rfc-3339=seconds) /usr/local/openssl/bin/openssl exists and is version $(/usr/local/openssl/bin/openssl version)." >>$log
            if [[ -s /usr/bin/openssl ]]; then
                echo "$(date --rfc-3339=seconds) Moving old openssl binary to /root." >>$log
                mv /usr/bin/openssl /root/
            fi

            # /usr/local/openssl/bin/openssl exists and is version 1.1.1
            ln -s /usr/local/openssl/bin/openssl /usr/bin/openssl
            echo "$(date --rfc-3339=seconds) Symlinked /usr/local/openssl/bin/openssl to /usr/bin/openssl."
            echo "$(date --rfc-3339=seconds) /usr/bin/openssl is now $(sudo /usr/bin/openssl version)."
            exit 0
        fi
    fi

    if [[ -d /root/openssl-OpenSSL_1_1_1c ]]; then
        echo "$(date --rfc-3339=seconds) OpenSSL 1.1.1 was not found in /usr/local/openssl/bin/openssl. Moving to /root/openssl-OpenSSL_1_1_1c." >>$log
        # build directory exists
        cd /root/openssl-OpenSSL_1_1_1c || (echo "Unable to change directory to /root/openssl-OpenSSL_1_1_1c. Exiting." >&2 && exit 1)
        echo "$(date --rfc-3339=seconds) Configuring." >>$log
        ./config --prefix=/usr/local/openssl --openssldir=/usr/local/openssl shared zlib
        echo "$(date --rfc-3339=seconds) Running make." >>$log
        make
        echo "$(date --rfc-3339=seconds) Running make test." >>$log
        make test
        echo "$(date --rfc-3339=seconds) Running make install." >>$log
        make install
        if [[ -s /usr/bin/openssl ]]; then
            echo "$(date --rfc-3339=seconds) Moving old openssl binary to /root." >>$log
            mv /usr/bin/openssl /root/
        fi

        # /usr/local/openssl/bin/openssl exists and is version 1.1.1
        ln -s /usr/local/openssl/bin/openssl /usr/bin/openssl
        echo "$(date --rfc-3339=seconds) Symlinked /usr/local/openssl/bin/openssl to /usr/bin/openssl." >>$log
        echo "$(date --rfc-3339=seconds) /usr/bin/openssl is now $(sudo /usr/bin/openssl version)." >>$log
    fi
fi
