echo "[APNS] Delete node if already installed"
#check if node is already installed
[ -d /usr/local/sbin/node ] && \rm -rf /usr/local/sbin/node

echo "[APNS] Install node"
sudo tar -xvf /home/akkadianuser/packages/node.tar.xz -C /usr/local/sbin

echo "[APNS] Rename node"
sudo mv /usr/local/sbin/node-v16.14.2-linux-x64 /usr/local/sbin/node

echo "[APNS] Add node to bashrc"
echo NODE_HOME=/usr/local/sbin/node >> ~/.bashrc
echo PATH=\$NODE_HOME/bin:\$PATH >> ~/.bashrc

#echo "[APNS] Run source"
#source ~/.bashrc

#install apns
echo "[APNS] Install apns"
[ -d /var/www/apns ] && \rm -rf /var/www/apns
sudo tar -xvf /home/akkadianuser/packages/AkkadianPushNotificationService-1.0.1.tar.gz -C /var/www

#install apns service
echo "[APNS] Move apns.service to systemd service folder"
sudo mv -f /var/www/apns/apns.service /etc/systemd/system

#start apns service
echo "[APNS] Start apns service"
systemctl daemon-reload
systemctl start apns

#open port 6001
echo "[APNS] Open port 6001" >>/var/www/product_update/update.log
sudo firewall-cmd --zone=public --add-port=6001/tcp
sudo firewall-cmd --runtime-to-permanent
sudo firewall-cmd --reload