if [[ -d /opt/akkadian/aco-server/ ]]; then
    base=$(echo "/home/akkadianuser/universal_installer_scripts/post-scripts/")
    log_file=$(echo "/home/akkadianuser/logs/aco_installation.log")
else
    base=$(echo "/var/www/product_update/scripts/")
    log_file=$(echo "/var/www/product_update/update.log")
fi

############# This code updates the update_cli script without breaking the normal installation flow, from version 3.1 to version 3.3
\cp -Rf /home/akkadianuser/scripts/universal_updater/update_cli_3.3.sh /home/akkadianuser/scripts/universal_updater/update_cli.sh
\rm -Rf /home/akkadianuser/scripts/universal_updater/update_cli_3.3.sh
######################################################################################################################################

if grep -Fxq "trap \"\" 2" /home/akkadianuser/.bashrc
then
  echo "nothing"
else
  sed -i '1s/^/trap "" 2\n/' /home/akkadianuser/.bashrc
  sed -i '1s/^/trap "" 20\n/' /home/akkadianuser/.bashrc
fi
############ Updates /var/www/html/update contents so user doesn't have to ssh into akkadianuser account #############################
if [[ ! -d /opt/akkadian/aco-server ]]; then
    echo "Deploying updater folder." >> "$log_file"
    sh /var/www/product_update/scripts/deploy_updater_folder.sh
fi

############ Update .my.cnf so we can access the database ############################################################################
if [[ -d /var/www/html/pme || -d /var/www/html/asb ]]; then
  sudo yes | cp -Rf /home/akkadianuser/.my_pme.cnf /home/akkadianuser/.my.cnf
elif [[ -d /var/www/html/acm ]]; then
  sudo yes | cp -Rf /home/akkadianuser/.my_acm.cnf /home/akkadianuser/.my.cnf
fi
sudo rm -Rf /home/akkadianuser/.my_pme.cnf
sudo rm -Rf /home/akkadianuser/.my_acm.cnf

######################################################################################################################################
echo "Running general_postscript getting base for repo" >> "$log_file"
sh /home/akkadianuser/upgrades/akkadian_repo/add_akkadian_repo.sh >> "$log_file"

echo "Running python update" >> "$log_file"

if [[ -d /opt/akkadian/aco-server ]]; then
    sh /home/akkadianuser/upgrades/python3.7/install_python379.sh >> "$log_file"

else

    echo "Running mariadb upgrade" >> "$log_file"
    sh /home/akkadianuser/upgrades/galera/mariadb_upgrade.sh >> "$log_file"

    echo "Running Akkadian Service Monitor installation" >>/var/www/product_update/update.log
    sh /home/akkadianuser/upgrades/akkadian_service_monitor/install_asm.sh >>/var/www/product_update/update.log

    echo "Running python update" >>/var/www/product_update/update.log
    sh /home/akkadianuser/upgrades/python3.7/install_python379.sh >>/var/www/product_update/update.log

    echo "Running Akkadian CDR Collector installation" >>/var/www/product_update/update.log
    sh /home/akkadianuser/upgrades/akkadian_cdr_collector/install_akk_cdr.sh >>/var/www/product_update/update.log

    echo "Running Akkadian Failover Replica installation" >>/var/www/product_update/update.log
    sh /home/akkadianuser/upgrades/replica_failover/install_replica_failover_engine.sh >>/var/www/product_update/update.log

fi


################# Preventing things like: ssh username@ip something, so after running akk app manager, exit.
if grep -Fxq "exit" /home/akkadianuser/.bashrc; then
  echo "noting"
else
  echo "\nexit" >> /home/akkadianuser/.bashrc
fi

############ Making nano the by default editor ############
sudo yum -y install /home/akkadianuser/packages/nano-2.3.1-10.el7.x86_64.rpm
if grep -Fxq "export EDITOR=nano" /home/akkadianuser/.bashrc
then
  echo "noting"
else
  echo "export EDITOR=nano" >>/home/akkadianuser/.bashrc
fi

############ Enable root login by ssh in case is off ########################
sh /home/akkadianuser/scripts/ssh/permit_root_ssh_access_on.sh
sh $base"change_root_password.sh"

if [[ -d /var/www/html/pme || -d /var/www/html/asb ]]; then
  sudo yes | cp -Rf /home/akkadianuser/.my_pme.cnf /home/akkadianuser/.my.cnf
elif [[ -d /var/www/html/acm ]]; then
  sudo yes | cp -Rf /home/akkadianuser/.my_acm.cnf /home/akkadianuser/.my.cnf
fi
sudo rm -Rf /home/akkadianuser/.my_pme.cnf
sudo rm -Rf /home/akkadianuser/.my_acm.cnf

# Compile possible new python libraries section
base=$(echo "/home/akkadianuser/packages")
cd $base

#TODO: put an if that check python3 installation, if so go and run, if not, install this at rollback moment
tar -zxvf python-pam.tar.gz
sudo pip3 install python_pam-1.8.4-py2.py3-none-any.whl -f ./ --no-index --no-deps
cd /home/akkadianuser/
sudo python3 setup.py install

