
base=/home/akkadianuser/upgrades
scripts=/home/akkadianuser/scripts
sh $base/apm_installs/queue_daemons.sh
sh $scripts/apm/remove-security-sensitive-files.sh

# -w searches for an exact match
# -q Quiet; do not write anything to standard output.  Exit immediately with zero status if any match is found, even if an error was detected.
# the echo $? will give me 0 if found and nothing if not found
found=$(grep -wq "python" /usr/local/bin/supervisorctl && echo $?)
if [ "$found" == "0" ]; then
  sed -i 's,#!/usr/bin/python,#!/usr/bin/python3,g' /usr/local/bin/supervisord
  sed -i 's,#!/usr/bin/python,#!/usr/bin/python3,g' /usr/local/bin/supervisorctl
fi

SERVICE_FILE=/etc/systemd/system/pause-jobs-flush-beanstalk.service
#https://www.linode.com/docs/guides/start-service-at-boot/
echo "Copying service file to systemd directory" > /home/akkadianuser/logs/beanstalkd-service.log 2>&1
sudo cp /home/akkadianuser/scripts/beanstalk/pause-jobs-flush-beanstalk.service /etc/systemd/system/
systemctl daemon-reload
echo "Starting pause-jobs-flush-beanstalk service" >> /home/akkadianuser/logs/beanstalkd-service.log 2>&1
systemctl start pause-jobs-flush-beanstalk.service
echo "Reloading daemon" >> /home/akkadianuser/logs/beanstalkd-service.log 2>&1
systemctl enable pause-jobs-flush-beanstalk.service
echo "Enabling recovery service" >> /home/akkadianuser/logs/beanstalkd-service.log 2>&1
echo "Restarting recovery service" >> /home/akkadianuser/logs/beanstalkd-service.log 2>&1
systemctl restart pause-jobs-flush-beanstalk

#Rsyslog configuration
# create config file and give it apache ownership.
if [ ! -f "/etc/rsyslog.d/apm_rsyslog.conf" ]; then
  touch /etc/rsyslog.d/apm_rsyslog.conf
  chown apache:root /etc/rsyslog.d/apm_rsyslog.conf #give apache access but maintain root group
  chmod o+rwx /etc/rsyslog.d/apm_rsyslog.conf
fi
# copy watch_rsyslog service and start it
if [ -f "/home/akkadianuser/scripts/apm/rsyslog_files/watch_rsyslog.service" ]; then
  cp /home/akkadianuser/scripts/apm/rsyslog_files/watch_rsyslog.service /etc/systemd/system/watch_rsyslog.service
  chmod 0664 /etc/systemd/system/watch_rsyslog.service 
  systemctl daemon-reload
  systemctl start watch_rsyslog.service
fi
 
