import re
import subprocess
from subprocess import PIPE

import click

import configparser
mapper = configparser.RawConfigParser()
mapper.read('mapper.ini')

import time

def change_posix_time(tz):
    tz2 = '\'' + tz + '\''
    p = subprocess.Popen(["export", 'TZ=' + tz2], stdout=PIPE, stderr=PIPE)

    click.echo('New date is: ', nl=False)
    p = subprocess.Popen(["sh", mapper.get('DateScripts', 'getDate')], stdout=PIPE, stderr=PIPE)

    for line in p.stdout:
        line = line.decode("utf-8")
        print(line)
    p.wait()

    time.sleep(3)


def execute_timezones():
    p = subprocess.Popen(["sh", mapper.get('DateScripts', 'timezoneScript')], stdout=PIPE, stderr=PIPE)
    p.wait()


def see_regions():
    regions = ['Africa', 'America', 'Antarctica', 'Arctic', 'Asia', 'Atlantic', 'Australia', 'Europe',
               'Indian', 'Pacific']

    utc = {"-11": "Pacific/Apia", "-10": "Pacific/Honolulu", "-9": "America/Whitehorse",
           "-8": "America/Anchorage", "-7": "America/Phoenix", "-6": "America/Denver",
           "-5": "America/Chicago", "-4": "America/New_York", "-3": "America/Argentina",
           "0": "Africa/Abidjan", "+1": "Europe/London",
           "+2": "Europe/Rome", "+3": "Europe/Bucharest", "+4": "Europe/Samara",
           "+5": "Asia/Oral", "+6": "Asia/Omsk", "+7": "Asia/Krasnoyarsk",
           "+8": "Australia/Perth", "+9": "Asia/Seoul", "+10": "Australia/Melbourne",
           "+11": "Asia/Srednekolymsk", "+12": "Pacific/Auckland", "+13": "Pacific/Apia"}

    click.clear()
    click.secho('0. Africa', fg='green')
    click.secho('1. Americas', fg='green')
    click.secho('2. Antarctica', fg='green')
    click.secho('3. Arctic Ocean', fg='green')
    click.secho('4. Asia', fg='green')
    click.secho('5. Atlantic Ocean', fg='green')
    click.secho('6. Australia', fg='green')
    click.secho('7. Europe', fg='green')
    click.secho('8. Indian Ocean', fg='green')
    click.secho('9. Pacific Ocean', fg='green')
    click.secho('p. Use Time Zone Offset', fg='green')
    click.secho('b. Back to Configure Time Menu', fg='red')

    click.secho('\nSelect an option: ', fg='white', blink=True, nl=False)
    try:
        char = click.getchar()
        click.echo('')

        if char == 'p':

            try:
                click.echo('Numbers from -11 to +13 are allowed.')
                shift = click.prompt('Please an offset from UTC (i.e: 0, -11, +13, -3)')

                click.echo('setting %s' % utc.get(shift))
                if shift == '-2' or shift == '-1':
                    click.pause('There is no city using this timezone. Press any key to continue...')
                else:
                    try:
                        set_timezones(utc.get(shift))

                    except:
                        click.pause('%s is not a valid offset. Ensure you have entered \"+\" or \"-\" next to the '
                                    'number. Press any key to continue...' % shift)
                        see_regions()
            except click.Abort:
                menu = 'time'

        elif char == 'b':
            menu = 'time'

        elif char.isdigit() and 0 <= int(char) <= 9:
            region = regions[int(char)]
            see_timezones(region)

        else:
            click.pause('Wrong choice, please select one from the list. Press any key to continue...')
            see_regions()

    except click.Abort:
        menu = 'time'


def see_timezones(region):
    click.clear()
    """See Available TimeZones """
    p = subprocess.Popen(["sh", mapper.get('DateScripts', 'seeTimeZones'), region], stdout=PIPE, stderr=PIPE)

    lines = []
    i = 1
    for line in p.stdout:
        line = line.decode("utf-8")
        lines.append('%s. ' % str(i) + ' ' + line)
        i += 1

    max_per_page = 20
    offset = 0
    total = len(lines)

    choice = ''
    while choice != 'e':
        click.clear()
        for line in lines[offset:offset + max_per_page]:
            click.echo(line, nl=False)

        choice = click.prompt('Previous p, Next n, Select a locale by number (Press e to exit)')

        if choice == 'p':
            if offset > 0:
                offset -= max_per_page
        elif choice == 'n':
            if offset + max_per_page < total:
                offset += max_per_page
        elif choice.isdigit():
            if int(choice) <= total:
                click.echo('setting timezone to: %s' % lines[int(choice) - 1].rstrip('\n').split()[1])
                time.sleep(1)
                timezone = region + '/' + lines[int(choice) - 1].rstrip('\n').split()[1]
                set_timezones(timezone)
                return
            else:
                click.echo('Please select a valid line')
                time.sleep(2)


def set_timezones(timezone):
    delete_timezone()

    timezone2 = timezone.replace("\n", "")

    p = subprocess.Popen(["sh", mapper.get('DateScripts', 'setTimeZone'), timezone2], stdout=PIPE, stderr=PIPE)

    for line in p.stdout:
        line = line.decode("utf-8")
        print(line)

    p.wait()

    click.secho('Writing time zone into ini file...', fg="yellow")

    p = subprocess.Popen(["sh", mapper.get('GeneralScripts', 'writeTimeZoneIntoIni'), timezone2], stdout=PIPE, stderr=PIPE)

    for line in p.stdout:
        line = line.decode("utf-8")
        print(line)

    p.wait()

    if p.returncode != 0:
        click.secho('[FAIL] Time Zone Could not be set', fg="red")
    else:
        click.secho('[OK] Time Zone Set Successfully', fg="yellow")

    time.sleep(2)


def delete_timezone():
    p = subprocess.Popen(["sh", mapper.get('DateScripts', 'deleteTimeZone')], stdout=PIPE, stderr=PIPE)

    for line in p.stdout:
        line = line.decode("utf-8")
        print(line)
    p.wait()

    if p.returncode != 0:
        click.secho(
            '[FAIL] Time Zone could not be deleted since set to UTC.\n  Time Zone may have previously been deleted.',
            fg="red")
    else:
        click.secho('[OK] Time Zone Deleted Successfully', fg="yellow")

    time.sleep(5)


def get_timezone():
    """Get TimeZone"""
    p = subprocess.Popen(["sh", mapper.get('DateScripts', 'getTimeZone')], stdout=PIPE, stderr=PIPE)
    status_ = []
    for line in p.stdout:
        line = line.decode("utf-8")
        if line.rstrip('\n') is not None and line.rstrip('\n') is not "":
            click.echo(line)
            status_.append(line)

    p.wait()

    if p.returncode != 0:
        click.secho('[FAIL] Undetermined Time Zone', fg="red")

    if len(status_) == 0:
        click.secho('[OK] Time Zone has not been set', fg="yellow")

    time.sleep(3)


def updateNTPServers(values_to_update):
    values_to_update = []
    click.secho('GET NTP SERVER URLS AT http://www.pool.ntp.org/en/', fg='yellow', bg='red')
    click.secho('Ex: Server 0: svr.pool.ntp.org', fg='yellow', bg='red')
    value = click.prompt('Server 0', type=str)
    value = value.replace("\n", "")
    values_to_update = values_to_update + [value]

    if click.confirm('Do you want to add another NTP Server?'):
        value = click.prompt('Server 1', type=str)
        value = value.replace("\n", "")
        values_to_update = values_to_update + [value]
        if click.confirm('Do you want to add another NTP Server?'):
            value = click.prompt('Server 2', type=str)
            value = value.replace("\n", "")
            values_to_update = values_to_update + [value]

            if click.confirm('Do you want to add another NTP Server?'):
                value = click.prompt('Server 3', type=str)
                value = value.replace("\n", "")
                values_to_update = values_to_update + [value]
                click.secho('Changes to be saved:', fg='green')

                for i in range(len(values_to_update)):
                    click.secho('Server %s' % str(i) + ': ' + values_to_update[i], fg='green')

                if click.confirm('Do you want to save changes?'):
                    set_servers_ntp_file(mapper.get('GeneralConfigs', 'ntp_file'), values_to_update)

    return values_to_update


def stop_ntp():
    p = subprocess.Popen(["sh", mapper.get('DateScripts', 'NTPStop')], stdout=PIPE, stderr=PIPE)

    for line in p.stdout:
        line = line.decode("utf-8")
        click.echo(line)
    p.wait()

    if p.returncode != 0:
        click.secho('[FAIL] Cannot reach the service, is it running?', fg="red")
    else:
        click.secho('[OK] NTP Server is down', fg="yellow")

    time.sleep(5)


def start_ntp():
    p = subprocess.Popen(["sh", mapper.get('DateScripts', 'NTPStart')], stdout=PIPE,
                         stderr=PIPE)
    for line in p.stdout:
        line = line.decode("utf-8")
        click.echo(line)
    p.wait()

    if p.returncode != 0:
        click.secho('[FAIL] There was a problem starting the service', fg='red')
    else:
        click.secho('[OK] NTP Server is up', fg="yellow")

    time.sleep(5)


def ntp_status():
    p = subprocess.Popen(["sh", mapper.get('DateScripts', 'NTPStatus')], stdout=PIPE,
                         stderr=PIPE)
    for line in p.stdout:
        line = line.decode("utf-8")
        ntp_status_ = line
    p.wait()

    if ntp_status_.rstrip('\n') is not None and ntp_status_.rstrip('\n') is not "":
        tokens = ntp_status_.split(',')

        for i in range(len(tokens)):
            if 'stratum' in tokens[i]:
                return int(tokens[i].split('=')[1])

    return 17


def set_servers_ntp_file(infile, value_to_change):
    try:
        inf = open(infile, 'r')
        lines = inf.readlines()

        inf = open(infile, 'w')

        for line in lines:
            line_words = line.split(' ')
            if line_words[0] != 'server':
                inf.write(line)

        for i in range(len(value_to_change)):
            inf.write("server " + value_to_change[i] + ' iburst\n')

    except:
        click.pause(
            'NTP Services were not updated correctly. Check if service is installed ( option 7 ) Press any key to continue...')

    return True


def get_servers_ntp_file(infile):
    try:
        inf = open(infile, 'r')
        lines = inf.readlines()
        servers = []

        for line in lines:
            line_words = line.split(' ')
            if line_words[0] == 'server':
                servers.append(line)
    except:
        click.pause('NTP Services error. Check if service is installed ( option 7 ) Press any key to continue...')

    return servers


def install_ntp():
    click.pause('NTP Services is about to be installed...')
    p = subprocess.Popen(["sh", mapper.get('DateScripts', 'NTPInstall')],
                         stdout=PIPE, stderr=PIPE)
    i = 0
    for line in p.stdout:
        line = line.decode("utf-8")
        i + 1
        print(line)
    p.wait()

    click.pause('NTP Services were updated correctly. Press any key to continue...')
    return


def change_timezone(ctx, menu):
    try:
        click.pause('\nIf date has being set before, using NTP or manually this change will not modify the system hour.'
                    '\nPress any key to continue...')

        if click.confirm('\nTime Zones are shown in a paged list. When you find the desired \n'
                         'Time Zone please enter the number tied to it. If you need to look \n'
                         'into more pages, please press n, to go to previous pages press p \n'
                         '\nAre you ready?'):
            ctx.invoke(see_regions)

    except click.Abort:
        menu = 'time'

    return menu


def is_valid_time(time):
    try:

        res = re.match('^(0[0-9]|1[0-9]|2[0-3]|[0-9]):[0-5][0-9]$', str(time))
        # click.secho('res:' + str(res))
        return (res != None and res != False)

    except Exception:
        click.secho('ERROR:' + str(Exception))
        return False


def is_valid_dayofweek(day):
    try:
        result = len(day) == 1 and day in "0123456"
        # click.secho('result:' + str(result))
        return result
    except Exception:
        click.secho('ERROR:' + str(Exception))
        return False


@click.option('--date', prompt='date in MMDDhhmmYYYY format')
def set_date(date):
    """Set Date Manually"""
    p = subprocess.Popen(["sh", mapper.get('DateScripts', 'setDate'), date], stdout=PIPE,
                         stderr=PIPE)
    for line in p.stdout:
        line = line.decode("utf-8")
        print(line)
    p.wait()

    if p.returncode != 0:
        print(p.returncode)

    time.sleep(5)


def get_date():
    """Get Current Date """
    p = subprocess.Popen(["sh", mapper.get('DateScripts', 'getDate')], stdout=PIPE, stderr=PIPE)
    for line in p.stdout:
        line = line.decode("utf-8")
        print(line)
    p.wait()

    if p.returncode != 0:
        print(p.returncode)

    p.wait()

    time.sleep(3)