import time
from subprocess import Popen, PIPE

import click

import configparser
mapper = configparser.RawConfigParser()
mapper.read('mapper.ini')


def supervisor_stop():
    click.echo('Stopping...')
    p = Popen(["sh", mapper.get('GeneralScripts', 'supervisorStop')], stdout=PIPE, stderr=PIPE)
    for line in p.stdout:
        line = line.decode("utf-8")
        print(line)
    p.wait()

    if p.returncode != 0:
        click.secho('[FAIL] Supervisor Could not be Stopped', fg="red")
    else:
        click.secho('[OK] Supervisor Stopped Successfully', fg="yellow")

    time.sleep(3)


def supervisor_start():
    click.echo('Starting...')
    p = Popen(["sh", mapper.get('GeneralScripts', 'supervisorStart')], stdout=PIPE, stderr=PIPE)
    for line in p.stdout:
        line = line.decode("utf-8")
        print(line)
    p.wait()

    if p.returncode != 0:
        click.secho('[FAIL] Supervisor Could not be Started', fg="red")
    else:
        click.secho('[OK] Supervisor Stopped Started', fg="yellow")

    time.sleep(3)


def supervisor_restart():
    click.echo('Restarting...')
    p = Popen(["sh", mapper.get('GeneralScripts', 'supervisorRestart')], stdout=PIPE, stderr=PIPE)
    for line in p.stdout:
        line = line.decode("utf-8")
        print(line)
    p.wait()

    if p.returncode != 0:
        click.secho('[FAIL] Supervisor Could not be restarted', fg="red")
    else:
        click.secho('[OK] Supervisor Stopped restarted', fg="yellow")

    time.sleep(3)


def supervisor_status():
    p = Popen(["sh", mapper.get('GeneralScripts', 'supervisorStatus')], stdout=PIPE, stderr=PIPE)
    for line in p.stdout:
        line = line.decode("utf-8")
        print(line)
    p.wait()

    click.pause('Please, press any key to continue...')