import os
import subprocess
import time
from subprocess import Popen, PIPE
import click

import src.cli_commons
from aco_management import aco_update
from network_management import reach_ip

import configparser

mapper = configparser.RawConfigParser()
mapper.read('mapper.ini')


def there_is_a_cli_update_in_folder():
    try:
        p = Popen(["sh", mapper.get('GeneralScripts', 'isCliUpdateAvailable')], stdout=PIPE, stderr=PIPE)
        lines = []
        for line in p.stdout:
            line = line.decode("utf-8")
            lines.append(line)

        result = lines[0]

        if "true" in result:
            return True
        else:
            return False

    except Exception as e:
        print(e)
    return False


def auto_update(zip_installer):

    p = subprocess.Popen(["sh", mapper.get('GeneralScripts', 'autoUpdate'), zip_installer],
                         stdout=PIPE, stderr=PIPE)

    time.sleep(10)

    for line in p.stdout:
        line = line.decode("utf-8")
        if 'ERROR' in line:
            click.secho(line, fg='red')
            click.secho('Akkadian Appliance Manager (AAM) was not updated.', fg='red')
            click.pause('Press any key to continue...')
            return
        else:
            click.secho(line)

    print('\n\n\n')
    click.secho('\n################## Akkadian Appliance Manager Update ################', fg='green')
    click.secho('Akkadian Appliance Manager (AAM) Updated.', fg='green')
    click.secho('\nA restart of AAM is required to enable any functionality and options to be accessible.', fg='green')
    click.secho('Use Option 2 under the \'Update Akkadian Appliance Manager\' menu to restart AAM.', fg='yellow')
    click.pause('Please press any key to continue...')
    return


def disable_auu_in_pme():
    p = Popen(["sh", mapper.get('GeneralScripts', 'disableAuuInPme')], stdout=PIPE, stderr=PIPE)
    for line in p.stdout:
        line = line.decode("utf-8")
        print(line)
    p.wait()

    click.pause('Please, press any key to continue...')


def ls_pme_updates_folder():
    p = subprocess.Popen(["sh", mapper.get('GeneralScripts', 'lsUpdateFolder')], stdout=PIPE,
                         stderr=PIPE)
    for line in p.stdout:
        line = line.decode("utf-8")
        print(line)
    p.wait()


def pme_update(currentversion, zipinstaller):
    """Update PME"""

    p = subprocess.Popen(["sh", mapper.get('ApplicationScripts', 'pmeUpdateScript'), currentversion, zipinstaller],
                         stdout=PIPE,
                         stderr=PIPE)

    for line in p.stdout:
        line = line.decode("utf-8")
        print(line)
    p.wait()

    out, err = p.communicate()
    time.sleep(10)

    if err:
        click.secho('PME Warning/Error')
        click.secho(err)
        click.pause('Press any key to continue...')
        return
    else:
        click.pause('PME was Updated correctly. Press any key to continue...')
        return


def push_installation(nodes):
    """Update PME"""

    nodes_string = ""
    for i in nodes:
        nodes_string += str(i) + " "

    p = subprocess.Popen(["sh", mapper.get('ApplicationScripts', 'pushScript'), nodes_string],
                         stdout=PIPE,
                         stderr=PIPE)

    for line in p.stdout:
        line = line.decode("utf-8")
        print(line)
    p.wait()

    out, err = p.communicate()

    if err:
        click.secho('Warning/Error')
        click.secho(err)
        click.pause('Press any key to continue...')
        return
    else:
        click.pause('Product was Updated correctly. Press any key to continue...')
        return


def getUpdate_name():
    try:
        p = Popen(["sh", mapper.get('GeneralScripts', 'getUpdateName')], stdout=PIPE, stderr=PIPE)
        lines = []
        for line in p.stdout:
            line = line.decode("utf-8")
            lines.append(line)

        return lines[0]

    except Exception as e:
        print(e)

    return ""


def installed_app_vs2():
    try:
        p = Popen(["sh", mapper.get('GeneralScripts', 'installedApp')], stdout=PIPE, stderr=PIPE)

        for line in p.stdout:
            line = line.decode("utf-8")
            if 'aco' in line:
                return 'aco'
            elif 'pme' in line:
                return 'pme'
            elif 'acm' in line:
                return 'acm'
            elif 'asb' in line:
                return 'asb'

    except Exception as e:
        print(e)
        return 'none'

    return 'none'


def enable_auu_in_pme():
    p = Popen(["sh", mapper.get('GeneralScripts', 'enableAuuInPme')], stdout=PIPE, stderr=PIPE)
    for line in p.stdout:
        line = line.decode("utf-8")
        line = line.decode("utf-8")
        print(line)
    p.wait()

    click.pause('Please, press any key to continue...')


def install_aco_from_url(ctx, menu):
    click.clear()
    click.secho('*********************************************', fg='green')
    click.secho('*********   CUCM Version settings ***********', fg='green')
    click.echo('Please enter Cisco Call Manager url you will use')
    click.secho(
        'if you are using two or more CUCM configurations that have different versions, you should enter the url of the minor one.',
        fg='red')
    cucm_url = click.prompt('Please enter CUCM url (ip address or domain name)', type=str)
    while not reach_ip(cucm_url):
        cucm_url = click.prompt('Please enter CUCM url (ip address or domain name)', type=str)
    cucm_url = 'https://' + cucm_url + ':8443/plugins/jtapi.jar'
    click.secho('Installing ACO...', fg='green')
    click.secho('You can press \'CTRL+C\' at any time to exit from an action\n'
                'and return to the previous menu.', fg='yellow')
    zip_installer = click.prompt('\nPlease enter the URL/Path for the ACO update files (tar.gz file)',
                                 type=str)
    if os.path.exists(zip_installer) or src.cli_commons.commons_manager.exists(zip_installer):
        click.secho(
            "After the installation, the server will reboot, you will lose all information not saved",
            fg='yellow')
        if click.confirm('Are you sure you want to continue?'):
            ctx.invoke(aco_update, zip_installer=zip_installer, jtapi_version=cucm_url)
        menu = 'update_aco'
    else:
        click.pause('Invalid URL/Path. Please try again.')
    return menu


def push_pme_cm_another_node(ctx, installed_app, menu):
    click.clear()
    click.secho('Pushing current installation into target nodes...', fg='green')
    click.secho('\nPlease follow the steps to push current installation into other instances',
                fg='green')
    value = click.prompt('Please enter the Target Hostname (maximum 15 characters).\nNode 1',
                         type=str).replace("\n", "")

    while not reach_ip(value) and value != 'quit':
        click.pause('Node is not reachable, please enter any key to continue...')
        value = click.prompt('Please enter the Target Hostname (maximum 15 characters). Press quit to Exit.\nNode 1',
                             type=str).replace("\n", "")

    if value == 'quit':
        menu = 'main'
        return

    ha_nodes = []
    ha_nodes += [value]
    confirm = True
    nodes_numbers = 2
    max_nodes_number = 9
    if installed_app == "aco":
        max_nodes_number = 4
    else:
        max_nodes_number = 9
    while (nodes_numbers < max_nodes_number and confirm):
        confirm = click.confirm('Do you want to push the product into another Node?')
        if confirm:
            value = click.prompt(
                'Node %s Please enter the Hostname (maximum 15 characters). Press quit to Exit.' % str(nodes_numbers + 1),
                type=str).replace("\n", "")
            while not reach_ip(value) and value != 'quit':
                click.pause('Node is not reachable, please enter any key to continue...')
                value = click.prompt(
                    'Node %s Please enter the Hostname (maximum 15 characters).' % str(
                        nodes_numbers + 1), type=str).replace("\n", "")
            if value == 'quit':
                menu = 'main'
                return

            ha_nodes += [value]
        nodes_numbers += 1
    ctx.invoke(push_installation, ha_nodes)
    click.pause('Every was pushed to specific nodes. Please press any key to continue...')
    menu = 'main'
    return menu


def pme_from_file_handler(ctx, menu):
    currentversion = mapper.get('GeneralConfigs', 'pmeBackupFileName')
    try:
        zipinstaller = see_files_in_folder(mapper.get('GeneralConfigs', 'pmeUploadFolder'))
        if zipinstaller != '':
            print('Installer found in:' + zipinstaller)
            ctx.invoke(pme_update, currentversion=currentversion, zipinstaller=zipinstaller)
        else:
            click.echo('Exit...')
            menu = 'update_pme'

    except click.Abort:
        menu = 'update_pme'
    return menu


def pme_from_url_handler(ctx, menu):
    click.clear()
    click.secho('Installing PME...', fg='green')
    currentversion = mapper.get('GeneralConfigs', 'pmeBackupFileName')
    try:
        zipinstaller = click.prompt('Please enter the URL for the PME Update file', type=str)
        if os.path.exists(zipinstaller) or src.cli_commons.commons_manager.exists(zipinstaller):
            ctx.invoke(pme_update, currentversion=currentversion, zipinstaller=zipinstaller)
            click.secho('Click b to return to the previous menu.')
        else:
            click.pause('Invalid URL. Please try again.')

    except click.Abort:
        menu = 'update_pme'
    return menu


def cm_update(zipinstaller):
    """Update ACM"""

    p = subprocess.Popen(["sh", mapper.get('ApplicationScripts', 'cmUpdateScript'), zipinstaller],
                         stdout=PIPE,
                         stderr=PIPE)

    for line in p.stdout:
        line = line.decode("utf-8")
        print(line)
    p.wait()

    out, err = p.communicate()
    time.sleep(10)

    if err:
        click.secho('ACM Warning/Error')
        click.secho(err)
        click.pause('Press any key to continue...')
        return
    else:
        click.pause('ACM was Updated correctly. Press any key to continue...')
        return


def see_files_in_folder(folder):
    click.clear()

    p = subprocess.Popen(["sh", mapper.get('GeneralScripts', 'seeFiles'), folder], stdout=PIPE, stderr=PIPE)

    lines = []
    i = 1
    for line in p.stdout:
        line = line.decode("utf-8")
        lines.append('%s. ' % click.style(str(i), fg='green') + click.style(line, fg='white'))
        i += 1

    max_per_page = 20
    offset = 0
    total = len(lines)

    if total == 0:
        click.echo('Could not find an Update file.')
        click.echo('Go to the following links to Upload the Update Files:\n')
        click.echo('Appliance Manager: <Server IP or Hostname>/appliance')
        click.echo('PME: <Server IP or Hostname>/pme/update and perform a Manual Update\n')
        click.pause('Please press any key to continue...')
        return ''

    choice = ''
    while choice != 'e':
        click.clear()
        for line in lines[offset:offset + max_per_page]:
            click.echo(line, nl=False)

        choice = click.prompt('Previous p, Next n, Select file line number (press e to exit)')

        if choice == 'p':
            if offset > 0:
                offset -= max_per_page
        elif choice == 'n':
            if offset + max_per_page < total:
                offset += max_per_page
        elif choice.isdigit():
            if int(choice) == 0:
                click.echo('Please select a valid file')
                time.sleep(2)
            elif int(choice) <= total:
                resp = lines[int(choice) - 1].rstrip('\n').split(' ')[1]
                click.echo('file to be used: %s' % resp + ' ...')
                time.sleep(1)
                return folder + '/' + resp
            else:
                click.echo('Please select a valid file')
                time.sleep(2)

    return ''


def is_local_aam_installation_allowed():
    p = Popen(["sh", mapper.get('GeneralScripts', 'isLocalInstallationAllowed')], stdout=PIPE, stderr=PIPE)
    for line in p.stdout:
        line = line.decode("utf-8")
        if 'True' in line:
            return True
        elif 'False' in line:
            return False


def set_local_aam_installation(allow_installation):
    p = subprocess.Popen(["sh", mapper.get('GeneralScripts', 'setLocalInstallation'), allow_installation], stdout=PIPE,
                         stderr=PIPE)

    return