import os

import click

import src.cli_commons
from src.products_installation_handler.products_installation_manager import cm_update


def update_acm_menu_handler(acm_option, char, ctx, menu):
    if acm_option == 'b':
        menu = 'main'

    elif acm_option == '1':
        click.clear()
        click.secho('Installing ACM...', fg='green')

        zipinstaller = click.prompt('Please enter the URI for the ACM Update file', type=str)
        if os.path.exists(zipinstaller) or src.cli_commons.commons_manager.exists(zipinstaller):
            ctx.invoke(cm_update, zipinstaller=zipinstaller)
            click.secho('Click b to return to the previous menu.')
        else:
            click.pause('Invalid URL. Please try again.')
    elif char == '2':
        menu = 'push_installation'
    elif char == '3':
        menu = 'aUU_menu'

    else:
        click.echo('Invalid input')
    return menu


def update_acm_menu():
    click.clear()
    click.secho('Update ACM', fg='green')
    click.secho('1: Update ACM using URL/Local Media', fg='green')
    click.secho('2: Push ACM using Local Installation', fg='green')
    click.secho('3: Akkadian Universal Updater', fg='green')
    click.secho('b: Back to Main Menu', fg='red')
    click.secho(
        'You can press \'CTRL+C\' at any time to exit from an action\nand return to the previous menu.',
        fg='yellow')