import time
from subprocess import Popen, PIPE

import click

from aco_management import tomcat_stop, tomcat_restart, tomcat_start, edit_logback, tail_f_acoweb
import configparser
mapper = configparser.RawConfigParser()
mapper.read('mapper.ini')


def tomcat_menu_handler(char, ctx, menu):
    if char == 'b':
        menu = 'main'

    elif char == '1':
        ctx.invoke(tomcat_stop)

    elif char == '2':
        ctx.invoke(tomcat_restart)

    elif char == '3':
        ctx.invoke(tomcat_start)

    elif char == '4':
        ctx.invoke(edit_logback)

    elif char == '5':
        ctx.invoke(tail_f_acoweb)

    elif char == '6':
        ctx.invoke(remove_tomcat_as_service)

    elif char == '7':
        ctx.invoke(start_and_add_tomcat_as_service)

    else:
        click.echo('Invalid input')
    return menu


def tomcat_menu():
    click.clear()
    click.secho('Web Console Service Settings', fg='green')
    click.secho('1: Stop Web Console Service', fg='green')
    click.secho('2: Restart Web Console Service', fg='green')
    click.secho('3: Start Web Console Service', fg='green')
    click.secho('4: See/Modify Web Console log level', fg='green')
    click.secho('5: See Web Console log in real time', fg='green')
    click.secho('6: Turn off Web auto start service (in case you use only thick client)', fg='green')
    click.secho('7: Turn on Web auto start service', fg='green')
    click.secho('b: Back to Main Menu', fg='red')
    click.secho('You can press \'CTRL+C\' at any time to exit from an action\n'
                'and return to the previous menu.', fg='yellow')


def remove_tomcat_as_service():
    click.echo('removing web console service...')
    p = Popen(["sh", mapper.get('GeneralScripts', 'tomcatRemove')], stdout=PIPE, stderr=PIPE)
    for line in p.stdout:
        line = line.decode("utf-8")
        print(line)
    p.wait()

    time.sleep(3)


def start_and_add_tomcat_as_service():
    click.echo('adding web console service...')
    p = Popen(["sh", mapper.get('GeneralScripts', 'tomcatAdd')], stdout=PIPE, stderr=PIPE)
    for line in p.stdout:
        line = line.decode("utf-8")
        print(line)
    p.wait()

    time.sleep(3)