import subprocess
from subprocess import PIPE

import click

from time_management import ntp_status, get_servers_ntp_file, stop_ntp, delete_timezone, start_ntp, change_timezone, \
    set_date, install_ntp
import configparser
mapper = configparser.RawConfigParser()
mapper.read('mapper.ini')

def handle_time_menu(char, ctx, menu):
    if char == '0':

        try:
            ntp_status_ = ntp_status()
            ntp_servers = get_servers_ntp_file(mapper.get('GeneralConfigs', 'ntp_file'))

            p = subprocess.Popen(["sh", mapper.get('DateScripts', 'getDate')], stdout=PIPE, stderr=PIPE)
            for line in p.stdout:
                line = line.decode("utf-8")
                date = line

            p = subprocess.Popen(["sh", mapper.get('DateScripts', 'getTimeZone')], stdout=PIPE, stderr=PIPE)
            for line in p.stdout:
                line = line.decode("utf-8")
                timezone = line
            click.clear()
            click.secho('******************************', fg='green')
            click.secho('Current Time Status', fg='green')

            if ntp_status_ < 16:
                click.echo('NTP Status: SYNCHRONIZED')
            else:
                click.echo('NTP Status: NOT SYNCHRONIZED')

            click.echo('\nNTP Sync Servers: ')
            click.echo(''.join(map(str, ntp_servers)))

            if date == '\n':
                click.echo('Current Date: is not configured')
            else:
                click.echo('Current Date: %s' % date)

            if timezone == '\n':
                click.echo('Current Time Zone: is not configured')
            else:
                click.echo('Current Time Zone: %s' % timezone)

            click.secho('******************************', fg='green')
            click.pause('Please press any key to continue...')
        except:
            click.pause(
                'There was a problem getting time settings, please install ntp (option 7), press any key to continue')
            menu = 'time'



    elif char == '1':
        ctx.invoke(stop_ntp)
        if click.confirm('Do you want to remove the Time Zone? (This will set the time to UTC.)'):
            ctx.invoke(delete_timezone)

    elif char == '2':
        ctx.invoke(start_ntp)
        if click.confirm('Do you want to change the Time Zone?'):
            menu = change_timezone(ctx, menu)

    elif char == '3':
        menu = 'sync-servers'

    elif char == '4':
        try:
            click.pause('Please enter the GMT date and time for the system time in the following format:\n'
                        'YYYYMMDDhhmm\n(ex. 201508151500, equivalent to 2015-08-15 3:00 PM GMT).\n\n'
                        'Date must also occur after year 2000 CE).\n\n'
                        'Note that this will stop NTP sync in case NTP service is up and running.\n'
                        'Press any key...')

            date = click.prompt('Date', type=str)

            while len(date) != 12 or not date.isdigit() or int(date[:4]) < 2000:
                date = click.prompt('Invalid Date.\nPlease enter the GMT date for the system time in the '
                                    'following format:\nYYYYMMDDhhmm\n(ex. 201508151500, equivalent to '
                                    '2015-08-15 3:00 PMGMT).\n\n '
                                    'Date must also occur after year 2000 CE).\n\n'
                                    'Note that this will stop NTP sync in case NTP service is up and'
                                    'running. Press quit to Exit\nDate', type=str)

            if date != 'quit':
                date_to_send = date[4:] + date[:4]
                ctx.invoke(set_date, date=date_to_send)

                if click.confirm('Do you want to change the Time Zone?'):
                    menu = change_timezone(ctx, menu)
            else:
                menu = 'main'

        except click.Abort:
            menu = 'time'

        except KeyboardInterrupt:
            menu = 'time'

    elif char == '5':
        _ = change_timezone(ctx, menu)

    elif char == '6':
        ctx.invoke(delete_timezone)

    elif char == '7':
        ctx.invoke(install_ntp)

    elif char == 'b':
        menu = 'main'
    return menu


def render_time_menu():
    click.clear()
    click.secho('Time Configurations', fg='green')
    click.secho('0: Current Time Status', fg='green')
    click.secho('1: NTP Stop Sync Up Service', fg='green')
    click.secho('2: NTP Start and Sync Up Service', fg='green')
    click.secho('3: NTP Set Sync Servers', fg='green')
    click.secho('4: Set Date Manually', fg='green')
    click.secho('5: Set Time Zone Manually', fg='green')
    click.secho('6: Remove Time Zone (Set to UTC)', fg='green')
    click.secho('7: Install NTP service', fg='green')
    click.secho('b: Back to Main Menu', fg='red')
    click.secho('You can press \'CTRL+C\' at any time to exit from an action\n'
                'and return to the previous menu.', fg='yellow')