import click

from supervisor_management import supervisor_stop, supervisor_restart, supervisor_start, supervisor_status


def supervisor_menu_handler(char, ctx, menu):
    if char == 'b':
        menu = 'main'

    elif char == '1':
        ctx.invoke(supervisor_stop)

    elif char == '2':
        ctx.invoke(supervisor_restart)

    elif char == '3':
        ctx.invoke(supervisor_start)

    elif char == '4':
        ctx.invoke(supervisor_status)
    return menu


def supervisor_menu():
    click.clear()
    click.secho('Supervisor Service Settings', fg='green')
    click.secho('1: Stop Supervisor Service', fg='green')
    click.secho('2: Restart Supervisor Service', fg='green')
    click.secho('3: Start Supervisor Service', fg='green')
    click.secho('4: Status Supervisor Service', fg='green')

    click.secho('b: Back to Main Menu', fg='red')
    click.secho('You can press \'CTRL+C\' at any time to exit from an action\n'
                'and return to the previous menu.', fg='yellow')