import click
import subprocess
from src.security_handler.security_handler import is_ssh_enable, disable_ssh, enable_ssh, is_allow_root_access_on, disable_root_ssh_access, enable_root_ssh_access
import configparser
mapper = configparser.RawConfigParser()
mapper.read('mapper.ini')


def render_security_menu():
    click.clear()
    click.secho('Akkadian Security Management', fg='green')

    is_ssh = is_ssh_enable()
    is_allow_root_access = is_allow_root_access_on()

    click.secho('Current Security Configuration:', fg='yellow')

    if is_ssh:
        click.secho("SSH access is enabled", fg='green')
        click.secho('1: Disable SSH access', fg='green')
    else:
        click.secho("SSH access is disabled", fg='green')
        click.secho('1: Enable SSH access', fg='green')

    if is_allow_root_access:
        click.secho("Root user SSH access is enabled", fg='green')
        click.secho('2: Disable root SSH access', fg='green')
    else:
        click.secho("Root user SSH access is disabled", fg='green')
        click.secho('2: Enable root SSH access', fg='green')

    click.secho('3: Change Appliance Manager user Password', fg='green')

    click.secho('b: Back to Main Menu', fg='red')
    click.secho('You can press \'CTRL+C\' at any time to exit from an action\n'
                'and return to the previous menu.', fg='yellow')


def security_menu_handler(char, menu):
    is_ssh = is_ssh_enable()
    is_allow_root_access = is_allow_root_access_on()

    if char == 'b':
        menu = 'main'
    elif char == '1' and is_ssh:
        disable_ssh()
    elif char == '1' and not is_ssh:
        enable_ssh()
    elif char == '2' and is_allow_root_access:
        disable_root_ssh_access()
    elif char == '2' and not is_allow_root_access:
        enable_root_ssh_access()
    elif char == '3':
        click.secho('Hit enter twice without input to cancel the change password action.', fg='yellow')
        subprocess.call(['passwd', 'akkadianuser'])

    return menu