import click

from openldap_management import see_ldap_settings, is_valid_ldap_basename, change_ldap_basedn, set_openldap_page


def openldap_menu_handler(char, menu):
    if char == 'b':
        menu = 'main'

    elif char == '1':
        see_ldap_settings()

    elif char == '2':
        click.clear()
        click.secho('Change Base DN', fg='green')
        value = click.prompt('Enter new Base DN ex. dc=company,dc=com')

        while not value:
            value = click.prompt('Enter new Base DN ex. dc=company,dc=com')

        if is_valid_ldap_basename(value) or click.confirm(
                'Base DN is not valid do you want to save the change?'):
            value = value.replace(" ", "")
            change_ldap_basedn(value)
        else:
            menu = 'openldap'
    elif char == '3':
        limit = click.prompt('Enter new page size value')
        set_openldap_page(limit)
    return menu


def openldap_menu():
    click.clear()
    click.secho('OpenLDAP Settings', fg='green')
    click.secho('1: Current OpenLDAP Settings', fg='green')
    click.secho('2: Change Base DN', fg='green')
    click.secho('3: Change Query Response Limit', fg='green')
    click.secho('b: Back to Main Menu', fg='red')
    click.secho('You can press \'CTRL+C\' at any time to exit from an action\n'
                'and return to the previous menu.', fg='yellow')