import click

from time_management import updateNTPServers, set_servers_ntp_file
import configparser
mapper = configparser.RawConfigParser()
mapper.read('mapper.ini')

def handle_ntp_sync_servers_menu(char, menu, values_to_update):
    if char == '1':
        try:
            if len(values_to_update) == 4:
                if click.confirm('The NTP servers have already been configured. '
                                 'Do you want to modify your changes?'):
                    values_to_update = updateNTPServers(values_to_update)
            else:
                values_to_update = updateNTPServers(values_to_update)

            if len(values_to_update) > 0:
                click.secho('[OK] NTP Servers Ready to be Saved', fg="yellow")
            else:
                click.secho('[FAIL] Servers have not being collected', fg="red")

        except click.Abort:
            menu = 'sync-servers'

    elif char == '2':
        menu = 'review_ntp_servers'

    elif char == '3':
        try:
            if click.confirm('Are you sure you want to save the configurations for the NTP servers?'):
                if len(values_to_update) > 0:
                    res = set_servers_ntp_file(mapper.get('GeneralConfigs', 'ntp_file'),
                                               values_to_update)
                    if res:
                        click.secho('[OK] NTP Servers Updated', fg="yellow")
                    else:
                        click.secho('[FAIL] NTP Servers Not Updated', fg="red")

                else:
                    click.secho('Please specify Servers')
        except click.Abort:
            menu = 'sync-servers'

    elif char == 'b':
        try:
            if click.confirm(
                    'Are you sure you want to exit?\nAny unsaved changes will not be preserved.'):
                menu = 'time'
        except click.Abort:
            menu = 'sync-servers'
    return menu, values_to_update


def ntp_sync_server_menu():
    click.clear()
    click.secho('Modify NTP Servers Menu...', fg='yellow')
    click.secho('1: Add NTP Servers', fg='green')
    click.secho('2: Review NTP Servers', fg='green')
    click.secho('3: Save NTP Servers', fg='green')
    click.secho('b: Back to Configure Time Menu', fg='red')
    click.secho('You can press \'CTRL+C\' at any time to exit from an action\n'
                'and return to the previous menu.', fg='yellow')


def review_ntp_servers_handler(menu, values_to_update):
    click.secho('Current NTP Servers to be Saved', fg='yellow')
    for i in range(len(values_to_update)):
        click.secho('Server %s' % str(i) + ': ' + values_to_update[i], fg='green')
    click.pause('Press any key to continue...')
    menu = 'sync-servers'
    return menu