import click

from aco_management import nginx_stop, nginx_restart, nginx_start, nginx_config


def nginx_menu_handler(char, ctx, menu):
    if char == 'b':
        menu = 'main'

    elif char == '1':
        ctx.invoke(nginx_stop)

    elif char == '2':
        ctx.invoke(nginx_restart)

    elif char == '3':
        ctx.invoke(nginx_start)

    elif char == '4':
        ctx.invoke(nginx_config)

    else:
        click.echo('Invalid input')
    return menu


def nginx_menu():
    click.clear()
    click.secho('Nginx Service Settings', fg='green')
    click.secho('1: Stop Nginx Service', fg='green')
    click.secho('2: Restart Nginx Service', fg='green')
    click.secho('3: Start Nginx Service', fg='green')
    click.secho('4: Override Nginx configs', fg='green')
    click.secho('b: Back to Main Menu', fg='red')
    click.secho('You can press \'CTRL+C\' at any time to exit from an action\n'
                'and return to the previous menu.', fg='yellow')