import click
import netifaces

from network_management import is_interface_up, get_current_hostname, nmtui, edit_proxy, restart_network, ping, \
    network_stop, network_start, network_restart
import configparser
mapper = configparser.RawConfigParser()
mapper.read('mapper.ini')

def network_menu_handler(char, ctx, dns1, dns2, gateway, interface, ip, menu, netmask):
    if char == '1':
        if is_interface_up(interface):
            addrs = netifaces.ifaddresses(interface)

            ipv4 = addrs[netifaces.AF_INET][0].get('addr')
            ipv4_netmask = addrs[netifaces.AF_INET][0].get('netmask')

            ipv6 = addrs[netifaces.AF_INET6][0].get('addr')
            ipv6_netmask = addrs[netifaces.AF_INET6][0].get('netmask')

            gws = netifaces.gateways()

            gateway = gws['default'][netifaces.AF_INET][0]

            # dns_ips = []
            lines = open(mapper.get('GeneralConfigs', 'network_interface_file') + interface,
                         'r').readlines()
            primary_dns = ''
            secondary_dns = ''

            for line in lines:
                columns = line.split('=')
                if columns[0] == 'DNS1':
                    primary_dns = columns[1]
                if columns[0] == 'DNS2':
                    secondary_dns = columns[1]

            click.clear()
            click.secho('******************************', fg='green')
            click.secho('Current Network Status & Configurations', fg='green')
            if (ipv4 is not None) and ipv4 != '':
                click.echo('Current IPv4:               %s' % ipv4)
            if (ipv4_netmask is not None) and ipv4_netmask != '':
                click.echo('Current IPv4 Netmask:       %s' % ipv4_netmask)
            if (primary_dns is not None) and primary_dns != '':
                click.echo('Current IPv4 Primary DNS:   %s' % primary_dns)
            if (secondary_dns is not None) and secondary_dns != '':
                click.echo('Current IPv4 Secondary DNS: %s' % secondary_dns)
            if (gateway is not None) and gateway != '':
                click.echo('Current IPv4 Gateway:       %s' % gateway)
            click.echo('Current Hostname:')
            ctx.invoke(get_current_hostname)
            click.secho('******************************', fg="green")
            click.pause('Please press any key to continue...')
        else:
            click.clear()
            click.secho('******************************', fg='green')
            click.secho('Current Network Status & Configurations', fg='green')
            click.secho('Network Interface is Offline')
            click.secho('******************************', fg='green')
            click.pause('Please press any key to continue...')
            menu = 'network'
    elif char == '2':
        ctx.invoke(nmtui)
    elif char == '3':
        ctx.invoke(edit_proxy)
        restart_network(ctx, interface)
    elif char == '4':
        host = click.prompt('Ping Host or IP Enter Hostname or IP')
        # TODO: how to validate this since it can be a hostname???
        ping(host)
    elif char == '5':
        if click.confirm(
                'Are you sure you want to stop this network interface? If this is your primary network interface, you may lose connection to this command prompt. '):
            ctx.invoke(network_stop, interface)
    elif char == '6':
        if click.confirm('Are you sure you want to start this network interface? '):
            ctx.invoke(network_start, interface)
    elif char == '7':
        if click.confirm(
                'Are you sure you want to restart this network interface? If this is your primary network interface, you may lose connection to this command prompt. '):
            ctx.invoke(network_restart, interface)
    elif char == 'b':
        if ip != '' or netmask != '' or dns1 != '' or dns2 != '' or gateway != '':
            if click.confirm(
                    'Do you want to leave this menu?\nAny unsaved changes will not be preserved.'):
                ip = ''
                netmask = ''
                dns1 = ''
                dns2 = ''
                gateway = ''
                menu = 'main'
        else:
            menu = 'main'
    return dns1, dns2, gateway, ip, menu, netmask


def network_menu():
    click.clear()
    click.secho('Update Network Configs', fg='green')
    click.secho('1: Review Current Network Configurations', fg='green')
    click.secho('2: Network Settings (nmtui tool)', fg='green')
    click.secho('3: Change proxy configurations', fg='green')
    click.secho('4: Ping Host or IP (ICMP)', fg='green')
    click.secho('5: Stop Network', fg='green')
    click.secho('6: Start Network', fg='green')
    click.secho('7: Restart Network', fg='green')
    click.secho('b: Back to Main Menu', fg='red')
    click.secho(
        'You can press \'CTRL+C\' at any time to exit from an action\nand return to the previous menu.',
        fg='yellow')