import click

from src.cli_commons.commons_manager import edit_my_ini, pme_mysql_stop, pme_mysql_start, pme_mysql_restart


def mysql_menu_handler(char, ctx, menu):
    if char == 'b':
        menu = 'main'

    elif char == '1':
        ctx.invoke(pme_mysql_stop)

    elif char == '2':
        ctx.invoke(pme_mysql_restart)

    elif char == '3':
        ctx.invoke(pme_mysql_start)

    elif char == '4':
        ctx.invoke(edit_my_ini)

    else:
        click.echo('Invalid input')
    return menu


def mysql_menu():
    click.clear()
    click.secho('MySQL Service Settings', fg='green')
    click.secho('1: Stop MySQL Service', fg='green')
    click.secho('2: Restart MySQL Service', fg='green')
    click.secho('3: Start MySQL Service', fg='green')
    click.secho('4: Edit MySQL Configuration (my.cnf)', fg='green')
    click.secho('b: Back to Main Menu', fg='red')
    click.secho('You can press \'CTRL+C\' at any time to exit from an action\n'
                'and return to the previous menu.', fg='yellow')
    click.secho('\nNOTE: The editor used by the application is the OS default\n'
                'loaded text editor \'nano\'.\n', fg='yellow')