import click

from aco_management import mongo_stop, mongo_restart, mongo_start


def mongo_menu_handler(char, ctx, menu):
    if char == 'b':
        menu = 'main'

    elif char == '1':
        ctx.invoke(mongo_stop)

    elif char == '2':
        ctx.invoke(mongo_restart)

    elif char == '3':
        ctx.invoke(mongo_start)

    else:
        click.echo('Invalid input')
    return menu


def mongo_menu():
    click.clear()
    click.secho('Mongo Service Settings', fg='green')
    click.secho('1: Stop Mongo Service', fg='green')
    click.secho('2: Restart Mongo Service', fg='green')
    click.secho('3: Start Mongo Service', fg='green')
    click.secho('b: Back to Main Menu', fg='red')
    click.secho('You can press \'CTRL+C\' at any time to exit from an action\n'
                'and return to the previous menu.', fg='yellow')