import configparser

import click
from network_management import get_ip, reach_ip
from src.ha_handler.ha_handler import (get_master, get_offlines, get_onlines,
                                       get_redundancy_nodelist, get_virtual_ip,
                                       is_full_ha_mode, is_ha_enable,
                                       is_replication_mode_only, maintenance_mode_on, maintenance_is_mode_on)

mapper = configparser.RawConfigParser()
mapper.read('mapper.ini')


def set_main_menu_margin_and_style():
    aam_version = mapper.get('GeneralConfigs', 'aam_version')
    border_width = 70
    border_character = '#'
    top_and_bottom_border = border_character * 70
    welcome_message_row = (border_character + ' Welcome to Akkadian Appliance Manager - %s' % aam_version).ljust(
        border_width - 1) + border_character
    padding_row_with_borders = border_character + (' ' * (border_width - 2)) + border_character
    click.clear()
    click.secho(top_and_bottom_border, fg='yellow')
    click.secho(padding_row_with_borders, fg='yellow')
    click.secho(welcome_message_row, fg='yellow')
    click.secho(padding_row_with_borders, fg='yellow')
    click.secho(top_and_bottom_border, fg='yellow')


def handle_main_menu_selection(char, installed_app, menu):
    if char == '1':
        menu = 'network'
    elif char == '2':
        menu = 'time'
    elif char == '3':
        menu = 'update_applications'
    elif char == '4':
        menu = 'general'
    elif char == '5':
        menu = 'autoupdate'
    elif char == '6':
        menu = 'high_availability'
    elif char == '7':
        menu = 'akkadian_executor'
    elif char == '8':
        menu = 'server_performance'
    elif char == 'x':
        menu = 'security'
    elif char == 'l':
        menu = 'logs'
    elif char == 'r':
        menu = 'reboot'
    elif char == 's':
        menu = 'shutdown'
    elif char == 'q':
        menu = 'quit'
    else:
        click.echo('Invalid input')
    return menu


def render_main_menu(char, installed_app, menu):
    render_ha_main_view(installed_app)

    click.secho('Main Menu:', fg='green')
    click.secho('  1: Configure Network', fg='green')
    click.secho('  2: Configure Time', fg='green')
    click.secho('  3: Update Akkadian Products', fg='green')
    click.secho('  4: Product Settings', fg='green')
    click.secho('  5: Appliance Manager Settings', fg='green')
    click.secho('  6: High Availability / Replication Support', fg='green')
    click.secho('  7: Akkadian Executor', fg='green')
    click.secho('  8: Server Performance Monitor', fg='green')
    click.secho('  x: Security Configuration', fg='green')
    click.secho('  l: System Logs', fg='green')
    click.secho('  r: Reboot Server', fg='green')
    click.secho('  s: Shutdown Server', fg='green')
    click.secho('  q: Quit Akkadian Appliance Manager', fg='red')
    click.secho('  You can press \'CTRL+C\' at any time to exit from an action\n'
                'and return to the previous menu.', fg='yellow')
    click.secho('\nUse the following url to access the application')
    click.secho('Secure URL, https://%s\n' % get_ip())


def render_ha_main_view(installed_app):
    is_replication_mode_only_variable = is_replication_mode_only(installed_app)
    is_full_ha_mode_var = is_full_ha_mode(installed_app)
    maintenance_is_mode_on_var = maintenance_is_mode_on()
    fg = 'green'

    if is_full_ha_mode_var:

        click.secho('#########################################################', fg='green')
        click.secho(' High Availability Mode Enabled', fg='blue')
        click.secho(' Master Node: %s ' % get_master(), fg='blue')
        click.secho(' Online: %s ' % get_onlines(), fg='green')

        offline_nodes = get_offlines()
        if offline_nodes and not offline_nodes.isspace():
            click.secho(' Offline: %s ' % offline_nodes, fg='red')

        virtual_ip = get_virtual_ip()
        click.secho(' VIP: %s ' % virtual_ip, fg='green')

    elif is_replication_mode_only_variable:
        node_list = get_redundancy_nodelist()

        click.secho('#########################################################', fg='green')
        click.secho(' Replication Mode Enabled', fg='green')
        click.secho(' Nodes: %s ' % node_list, fg='green')

        offline = ""
        online = ""

        nodes_list_array = node_list.split(' ')

        for i in range(0, len(nodes_list_array)):
            if reach_ip(nodes_list_array[i]):
                online = online + " " + nodes_list_array[i]
            else:
                offline = offline + " " + nodes_list_array[i]

        click.secho(' Online: %s ' % online, fg='green')

        if offline and not offline.isspace():
            click.secho(' Offline: %s ' % offline, fg='red')

    elif maintenance_is_mode_on_var:
        fg = 'yellow'
        click.secho('########### Replication Maintenance Mode ################', fg=fg)
        click.secho('Maintenance mode is enabled.', fg='green')
        click.secho('Database replication is currently disabled.', fg='green')
        click.secho('Disable maintenance mode to enable database replication.', fg='green')

    click.secho('#########################################################', fg=fg)
