import click
from asm_management import asm_logs, is_asm_installed
from cdr_management import cdr_logs, is_cdr_installed
from logs_handler import (show_auto_update_log, show_auu_installation_log,
                          show_ha_log_aco, show_ha_log_pme, show_init_ha_log,
                          show_init_ha_log_aco, show_init_replica_aco_log,
                          show_init_replica_apm_log, show_installation_aco_log,
                          show_installation_pme_log)
from src.ha_handler.ha_handler import is_full_ha_mode, is_replication_mode_only


def render_logs_menu(installed_app):

    is_replication_mode_only_variable = is_replication_mode_only(installed_app)
    is_full_ha_mode_var = is_full_ha_mode(installed_app)
    is_replica_on = is_replication_mode_only_variable or is_full_ha_mode_var
    cdr_installed = is_cdr_installed()
    asm_installed = is_asm_installed()

    click.clear()
    click.secho('Akkadian Appliance Manager Logs', fg='green')

    click.secho('1: Universal Updater Installation log', fg='green')
    click.secho('2: Appliance Manager Installation log', fg='green')
    click.secho('3: Product Installation log (APM, ACM, ACO, etc)', fg='green')
    if is_replica_on:
        click.secho('4: HA initialization process log', fg='green')
        click.secho('5: Database Replication initialization process log', fg='green')
        click.secho('6: High Availability Recovery log', fg='green')
    if cdr_installed:
        click.secho('7: Akkadian CDR Collector Logs', fg='green')
    if asm_installed:
        click.secho('8: Akkadian Service Monitor Logs', fg='green')

    click.secho('b: Back to Main Menu', fg='red')
    click.secho('You can press \'CTRL+C\' at any time to exit from an action\n'
                'and return to the previous menu.', fg='yellow')


def handle_logs_menu_selection(installed_app, char):
    try:
        is_replication_mode_only_variable = is_replication_mode_only(installed_app)
        is_full_ha_mode_var = is_full_ha_mode(installed_app)
        is_replica_on = is_replication_mode_only_variable or is_full_ha_mode_var
        cdr_installed = is_cdr_installed()
        asm_installed = is_asm_installed()

        if char == '1':
            show_auu_installation_log()
        if char == '2':
            show_auto_update_log()
        elif char == '3':
            if installed_app == 'pme_cm':
                show_installation_pme_log()
            elif installed_app == 'aco':
                show_installation_aco_log()
            else:
                show_installation_pme_log()

        elif char == '6' and is_replica_on:
            if installed_app == 'pme_cm':
                show_ha_log_pme()
            elif installed_app == 'aco':
                show_ha_log_aco()
            else:
                show_ha_log_pme()

        elif char == '5' and is_replica_on:
            if installed_app == 'pme_cm':
                show_init_replica_apm_log()
            elif installed_app == 'aco':
                show_init_replica_aco_log()
            else:
                show_init_replica_apm_log()

        elif char == '4' and is_replica_on:
            if installed_app == 'pme_cm':
                show_init_ha_log()
            elif installed_app == 'aco':
                show_init_ha_log_aco()
            else:
                show_init_ha_log()
        elif char == '7' and cdr_installed:
            cdr_logs()
        elif char == '8' and asm_installed:
            asm_logs()
        elif char == 'b':
            menu = 'main'
            return menu

    except click.Abort:
        print('click.Abort')
        menu = 'autoupdate'
        return menu
    except:
        menu = 'main'
        return menu

    menu = 'main'
    return menu
