import configparser

import click
from asm_management import is_asm_installed
from cdr_management import is_cdr_installed
from src.products_installation_handler.products_installation_manager import installed_app_vs2

mapper = configparser.RawConfigParser()
mapper.read('mapper.ini')


def handle_general_menu_selection_manager(char, menu, installed_app):
    installed_app = installed_app_vs2()
    cdr_installed = is_cdr_installed()
    asm_installed = is_asm_installed()

    if char == 'b':
        menu = 'main'

    elif char == '1':
        if installed_app == 'aco':
            menu = 'aco_services'
        elif installed_app == 'pme':
            menu = 'pme_services'
        elif installed_app == 'asb':
            menu = 'asb_services'
        elif installed_app == 'acm':
            menu = 'cm_services'

    elif char == '2':
        if asm_installed and cdr_installed:
            menu = 'asm_menu'
        elif asm_installed and not cdr_installed:
            menu = 'asm_menu'
        elif cdr_installed and not asm_installed:
            menu = 'cdr_menu'

    elif char == '3':
        if asm_installed and not cdr_installed:
            menu = 'aUU_menu'
        if cdr_installed and not asm_installed:
            menu = 'aUU_menu'
        if cdr_installed and asm_installed:
            menu = 'cdr_menu'

    elif char == '4':
        if asm_installed and cdr_installed:
            menu = 'aUU_menu'

    return menu


def render_general_view_products_menu():
    installed_app = installed_app_vs2()
    cdr_installed = is_cdr_installed()
    asm_installed = is_asm_installed()
    click.clear()
    click.secho('Products Settings', fg='green')
    if installed_app == 'pme':
        click.secho('1: Akkadian PM/HCS Services', fg='green')
    if installed_app == 'aco':
        click.secho('1: Akkadian Console Operator Services', fg='green')
    if installed_app == 'acm':
        click.secho('1: Akkadian Contact Manager Services', fg='green')
    if installed_app == 'asb':
        click.secho('1: Akkadian Site Builder Services', fg='green')
    if asm_installed and not cdr_installed:
        click.secho('2: Akkadian Service Monitor', fg='green')
        click.secho('3: Akkadian Universal Updater', fg='green')
    if cdr_installed and not asm_installed:
        click.secho('2: Akkadian CDR Collector', fg='green')
        click.secho('3: Akkadian Universal Updater', fg='green')
    if asm_installed and cdr_installed:
        click.secho('2: Akkadian Service Monitor', fg='green')
        click.secho('3: Akkadian CDR Collector', fg='green')
        click.secho('4: Akkadian Universal Updater', fg='green')

    click.secho('b: Back to Main Menu', fg='red')
