import click
from cdr_management import (cdr_logs, cdr_restart, cdr_start, cdr_status,
                            cdr_stop, edit_cdr_config, change_akksftpcdruser_pass)


def cdr_menu_handler(char, ctx, menu):
    if char == 'b':
        menu = 'main'

    elif char == '1':
        ctx.invoke(cdr_stop)

    elif char == '2':
        ctx.invoke(cdr_restart)

    elif char == '3':
        ctx.invoke(cdr_start)

    elif char == '4':
        ctx.invoke(cdr_status)

    elif char == '5':
        ctx.invoke(edit_cdr_config)
        
    elif char == '6':
        ctx.invoke(cdr_logs)

    elif char == '7':
        ctx.invoke(change_akksftpcdruser_pass)
    return menu


def cdr_menu():
    click.clear()
    click.secho('CDR Collector Service Settings', fg='green')
    click.secho('1: Stop CDR Collector Service', fg='green')
    click.secho('2: Restart CDR Collector Service', fg='green')
    click.secho('3: Start CDR Collector Service', fg='green')
    click.secho('4: Check the status of the CDR Collector Service', fg='green')
    click.secho('5: View and edit CDR Collector config parameters', fg='green')
    click.secho('6: View CDR Collector logs', fg='green')
    click.secho('7: Change akksftpcdruser password', fg='green')

    click.secho('b: Back to Main Menu', fg='red')
    click.secho('You can press \'CTRL+C\' at any time to exit from an action\n'
                'and return to the previous menu.', fg='yellow')
