import click
from asm_management import (asm_logs, asm_restart, asm_start, asm_status,
                            asm_stop, edit_asm_config)


def asm_menu_handler(char, ctx, menu):
    if char == 'b':
        menu = 'main'

    elif char == '1':
        ctx.invoke(asm_stop)

    elif char == '2':
        ctx.invoke(asm_restart)

    elif char == '3':
        ctx.invoke(asm_start)

    elif char == '4':
        ctx.invoke(asm_status)

    elif char == '5':
        ctx.invoke(edit_asm_config)

    elif char == '6':
        ctx.invoke(asm_logs)
    return menu


def asm_menu():
    click.clear()
    click.secho('Akkadian Service Monitor Service Settings', fg='green')
    click.secho('1: Stop Akkadian Service Monitor Service', fg='green')
    click.secho('2: Restart Akkadian Service Monitor Service', fg='green')
    click.secho('3: Start Akkadian Service Monitor Service', fg='green')
    click.secho('4: Check the status of the Akkadian Service Monitor Service', fg='green')
    click.secho('5: View and edit Akkadian Service Monitor config parameters', fg='green')
    click.secho('6: View Akkadian Service Monitor Logs ', fg='green')

    click.secho('b: Back to Main Menu', fg='red')
    click.secho('You can press \'CTRL+C\' at any time to exit from an action\n'
                'and return to the previous menu.', fg='yellow')
