import subprocess
from subprocess import PIPE

import click
from src.cli_commons.commons_manager import generate_non_aco_certificate
from src.products_installation_handler.products_installation_manager import installed_app_vs2
import configparser
mapper = configparser.RawConfigParser()
mapper.read('mapper.ini')


def apm_acm_services_menu_handler(char, installed_app, menu):

    if char == 'b':
        menu = 'main'
    elif char == '0':
        p = subprocess.Popen(["sh", mapper.get('GeneralScripts', 'apacheStatus')], stdout=PIPE,
                             stderr=PIPE)
        for line in p.stdout:
            line = line.decode("utf-8")
            apache_status = line

        mysql_status_lines = []
        p = subprocess.Popen(["sh", mapper.get('GeneralScripts', 'pmeMysqlStatus')], stdout=PIPE,
                             stderr=PIPE)
        for line in p.stdout:
            line = line.decode("utf-8")
            mysql_status_lines.append(line)

        click.clear()
        click.secho('******************************', fg='green')
        click.secho('Current Web Server Services Status', fg='green')

        click.secho('* Apache Current Status:', fg='yellow')
        if apache_status == '\n':
            click.echo('Apache Service is not installed\n')
        else:
            click.echo('%s' % apache_status)

        click.secho('* MySQL Current Status:', fg='yellow')
        if not mysql_status_lines:
            click.echo('MySQL Service is not installed\n')
        else:
            click.echo('%s' % ''.join(mysql_status_lines))

        click.secho('******************************', fg='green')
        click.pause('Please press any key to continue...')
    elif char == '1':
        menu = 'apache'

    elif char == '2':
        menu = 'pme_mysql'
    elif char == '3':
        if installed_app == 'acm':
            menu = 'openldap'
        else:
            menu = 'supervisor'
    elif char == '4':
        if installed_app == 'acm':
            menu = 'supervisor'
        else:
            generate_non_aco_certificate()
    elif char == '5':
        generate_non_aco_certificate()

    return menu


def apm_acm_services_menu(menu):
    click.clear()
    app = installed_app_vs2()
    if menu == 'pme_services':
        click.secho('APM Product Settings', fg='green')
    elif menu == 'cm_services':
        click.secho('ACM Product Settings', fg='green')
    elif menu == 'asb_services':
        click.secho('ASB Product Settings', fg='green')
    click.secho('0: Current Web Server Status', fg='green')
    click.secho('1: Apache Service', fg='green')
    click.secho('2: MySQL Service', fg='green')
    if app == 'acm':
        click.secho('3: OpenLDAP Settings', fg='green')
        click.secho('4: Supervisor Service', fg='green')
        click.secho('5: Generate Certificate', fg='green')
    else:
        click.secho('3: Supervisor Service', fg='green')
        click.secho('4: Generate Certificate', fg='green')
    click.secho('b: Back to Main Menu', fg='red')