import subprocess

import click

from apache_management import apache_stop, apache_restart, apache_start
from src.cli_commons.commons_manager import edit_php_ini, edit_apache_configs


def apache_menu_handler(char, ctx, menu):
    if char == 'b':
        menu = 'main'

    elif char == '1':
        ctx.invoke(apache_stop)

    elif char == '2':
        ctx.invoke(apache_restart)

    elif char == '3':
        ctx.invoke(apache_start)

    elif char == '4':
        ctx.invoke(edit_php_ini)

    elif char == '5':
        ctx.invoke(edit_apache_configs)

    elif char == 'c':
        click.edit(filename='/var/spool/cron/akkadianuser')

    else:
        click.echo('Invalid input')
    return menu


def apache_menu():
    click.clear()
    click.secho('Apache Service Settings', fg='green')
    click.secho('1: Stop Apache Service', fg='green')
    click.secho('2: Restart Apache Service', fg='green')
    click.secho('3: Start Apache Service', fg='green')
    click.secho('4: Edit PHP Configuration (php.ini)', fg='green')
    click.secho('5: Edit Apache Configuration (httpd.conf)', fg='green')
    click.secho('c: Edit cron File for Apache', fg='green')
    click.secho('b: Back to Main Menu', fg='red')
    click.secho('You can press \'CTRL+C\' at any time to exit from an action\n'
                'and return to the previous menu.', fg='yellow')
    click.secho('\nNOTE: The editor used by the application is the OS default\n'
                'loaded text editor \'nano\'.\n', fg='yellow')