import click

from src.akkadian_executor.executor_manager import stop_akkadian_executor, start_akkadian_executor, \
    status_akkadian_executor


def handle_akkadian_executor_selection(char, ctx, menu):
    if char == '1':
        ctx.invoke(stop_akkadian_executor)
    elif char == '2':
        ctx.invoke(start_akkadian_executor)
    elif char == '3':
        ctx.invoke(status_akkadian_executor)
    elif char == 'b':
        menu = 'main'
    return menu


def render_akkadian_executor_menu():
    click.clear()
    click.secho('Akkadian Executor Management', fg='green')
    click.secho('1: Stop Akkadian Executor', fg='green')
    click.secho('2: Start Akkadian Executor', fg='green')
    click.secho('3: See Akkadian Executor Status', fg='green')
    click.secho('b: Back to Main Menu', fg='red')
    click.secho('You can press \'CTRL+C\' at any time to exit from an action\n'
                'and return to the previous menu.', fg='yellow')