import subprocess
from subprocess import PIPE

import click

from aco_management import get_jtapi, generate_aco_certificate
from network_management import reach_ip
import configparser
mapper = configparser.RawConfigParser()
mapper.read('mapper.ini')


def aco_services_menu_handler(char, menu):
    if char == 'b':
        menu = 'main'

    elif char == '0':
        p = subprocess.Popen(["sh", mapper.get('GeneralScripts', 'kestrelStatus')], stdout=PIPE,
                             stderr=PIPE)

        kestrel_status_lines = []
        for line in p.stdout:
            line = line.decode("utf-8")
            kestrel_status_lines.append(line)

        p = subprocess.Popen(["sh", mapper.get('GeneralScripts', 'mongoStatus')], stdout=PIPE,
                             stderr=PIPE)

        mongo_status_lines = []
        for line in p.stdout:
            line = line.decode("utf-8")
            mongo_status_lines.append(line)

        p = subprocess.Popen(["sh", mapper.get('GeneralScripts', 'acoMysqlStatus')], stdout=PIPE,
                             stderr=PIPE)

        mysql_status_lines = []
        for line in p.stdout:
            line = line.decode("utf-8")
            mysql_status_lines.append(line)

        p = subprocess.Popen(["sh", mapper.get('GeneralScripts', 'nginxStatus')], stdout=PIPE,
                             stderr=PIPE)

        nginx_status_lines = []
        for line in p.stdout:
            line = line.decode("utf-8")
            nginx_status_lines.append(line)

        p = subprocess.Popen(["sh", mapper.get('GeneralScripts', 'tomcatStatus')], stdout=PIPE,
                             stderr=PIPE)

        tomcat_status_lines = []
        for line in p.stdout:
            line = line.decode("utf-8")
            tomcat_status_lines.append(line)

        click.clear()
        click.secho('******************************', fg='green')
        click.secho('Current ACO Services Status', fg='green')

        click.secho('* Kestrel Current Status:', fg='yellow')
        if not kestrel_status_lines:
            click.echo('Kestrel Service is not installed\n')
        else:
            click.echo('%s' % ''.join(kestrel_status_lines))

        click.secho('* Mongo Current Status:', fg='yellow')
        if not mongo_status_lines:
            click.echo('Mongo Service is not installed\n')
        else:
            click.echo('%s' % ''.join(mongo_status_lines))

        click.secho('* MySQL Current Status:', fg='yellow')
        if not mysql_status_lines:
            click.echo('MySQL Service is not installed\n')
        else:
            click.echo('%s' % ''.join(mysql_status_lines))

        click.secho('* Nginx Current Status:', fg='yellow')
        if not nginx_status_lines:
            click.echo('Nginx Service is not installed\n')
        else:
            click.echo('%s' % ''.join(nginx_status_lines))

        click.secho('* Tomcat Current Status:', fg='yellow')
        if not tomcat_status_lines:
            click.echo('Tomcat Service is not installed\n')
        else:
            click.echo('%s' % ''.join(tomcat_status_lines))

        click.secho('******************************', fg='green')
        click.pause('Please press any key to continue...')

    elif char == '1':
        menu = 'kestrel'

    elif char == '2':
        menu = 'mongo'

    elif char == '3':
        menu = 'aco_mysql'

    elif char == '4':
        menu = 'nginx'

    elif char == '5':
        menu = 'tomcat'

    elif char == '6':
        click.echo('Please enter Cisco Call Manager url you will use')
        click.secho(
            'if you are using two or more CUCM configurations with different versions, you should enter the url of the minor one.',
            fg='red')
        cucm_url = click.prompt('Please enter CUCM url (ip address or domain name)', type=str)

        while not reach_ip(cucm_url):
            cucm_url = click.prompt('Please enter CUCM url (ip address or domain name)', type=str)

        cucm_url = 'https://' + cucm_url + '/plugins/jtapi.jar'
        get_jtapi(cucm_url)
    elif char == '7':
        menu = 'crontomcat'

    elif char == '8':
        generate_aco_certificate()
    return menu


def aco_services_menu():
    click.clear()
    click.secho('ACO Services Settings', fg='green')
    click.secho('0: Current ACO Services Status', fg='green')
    click.secho('1: ACO Server (Kestrel) management', fg='green')
    click.secho('2: Mongo (Server DB) management', fg='green')
    click.secho('3: MySQL (Web Console DB) management', fg='green')
    click.secho('4: Smart Proxy (Nginx) management', fg='green')
    click.secho('5: ACO Web (Tomcat) management', fg='green')
    click.secho('6: Load jtapi library', fg='green')
    click.secho('7: Schedule Sync Job', fg='green')
    click.secho('8: Generate General Certificates', fg='green')
    click.secho('b: Back to Main Menu', fg='red')
    click.secho('You can press \'CTRL+C\' at any time to exit from an action\n'
                'and return to the previous menu.', fg='yellow')