import click

from aco_management import aco_mysql_stop, aco_mysql_restart, aco_mysql_start


def aco_mysql_menu_handler(char, ctx, menu):
    if char == 'b':
        menu = 'main'

    elif char == '1':
        ctx.invoke(aco_mysql_stop)

    elif char == '2':
        ctx.invoke(aco_mysql_restart)

    elif char == '3':
        ctx.invoke(aco_mysql_start)

    else:
        click.echo('Invalid input')
    return menu


def aco_mysql_menu():
    click.clear()
    click.secho('MySQL Service Settings', fg='green')
    click.secho('1: Stop MySQL Service', fg='green')
    click.secho('2: Restart MySQL Service', fg='green')
    click.secho('3: Start MySQL Service', fg='green')
    click.secho('b: Back to Main Menu', fg='red')
    click.secho('You can press \'CTRL+C\' at any time to exit from an action\n'
                'and return to the previous menu.', fg='yellow')