import click

from aco_management import reset_aco_admin_pass, kestrel_stop, kestrel_restart, kestrel_start, kestrel_configs, \
    edit_acolog, tail_f_acoserver, remove_events_duplicated, see_console_events, see_console_events_web


def aco_detailed_services_menu_handler(char, ctx, menu):
    if char == 'b':
        menu = 'main'

    elif char == 'r':
        ctx.invoke(reset_aco_admin_pass)

    elif char == '1':
        ctx.invoke(kestrel_stop)

    elif char == '2':
        ctx.invoke(kestrel_restart)

    elif char == '3':
        ctx.invoke(kestrel_start)

    elif char == '4':
        ctx.invoke(kestrel_configs)

    elif char == '5':
        ctx.invoke(edit_acolog)

    elif char == '6':
        ctx.invoke(tail_f_acoserver)

    elif char == '7':
        ctx.invoke(remove_events_duplicated)

    elif char == '8':
        ctx.invoke(see_console_events)

    elif char == '9':
        ctx.invoke(see_console_events_web)

    else:
        click.echo('Invalid input')
    return menu


def aco_services_detailed_menu():
    click.clear()
    click.secho('ACO Server Service and Settings', fg='green')
    click.secho('1: Stop ACO Server', fg='green')
    click.secho('2: Restart ACO Server', fg='green')
    click.secho('3: Start ACO Server', fg='green')
    click.secho('4: Override ACO Server configs (Increase File Descriptor Configs)', fg='green')
    click.secho('5: See/Modify ACO Server log level', fg='green')
    click.secho('6: See logs in Real Time', fg='green')
    click.secho('7: Remove duplicated Console Events', fg='green')
    click.secho('8: See Amount of Console Events', fg='green')
    click.secho('9: See Amount of Console Events coming from web', fg='green')
    click.secho('r: Reset Admin password', fg='green')
    click.secho('b: Back to Main Menu', fg='red')
    click.secho('You can press \'CTRL+C\' at any time to exit from an action\n'
                'and return to the previous menu.', fg='yellow')