import os
import subprocess

import click

from snmp_management import is_snmp_enabled, disable_snmp, enable_snmp, edit_snmp_configs, enable_snmpv3, \
    is_snmpv3_enable
from src.cli_commons.commons_manager import exists, kick_off, chown, is_encryption_enabled, disable_encryption_mode, \
    enable_encryption_mode
from src.menu_renderer.main_menu_manager import mapper
from src.products_installation_handler.products_installation_manager import there_is_a_cli_update_in_folder, \
    auto_update, \
    is_local_aam_installation_allowed, set_local_aam_installation
from network_management import toggle_akkadian_repo_check, akkadian_repo_check_is_enabled


def handle_auto_update_selection(char, ctx, menu):
    is_aam_installation_allowed = is_local_aam_installation_allowed()

    if char == '0':

        aam_version = mapper.get('GeneralConfigs', 'aam_version')

        click.clear()
        click.secho('******************************', fg='green')
        click.secho('Current Appliance Manager Version', fg='green')
        click.echo('version: %s' % aam_version)
        click.secho('******************************', fg='green')
        click.pause('Please press any key to continue...')

    elif char == '1':
        try:
            if is_aam_installation_allowed:
                there_is_a_cli_update_in_folder_var = there_is_a_cli_update_in_folder()
                if there_is_a_cli_update_in_folder_var:
                    click.secho(' There is a new CLI update', fg='green')
                    if click.confirm('Do you want to install it from the default location?'):
                        # run it now!!
                        ctx.invoke(auto_update, "cli_updates")
                        menu = 'main'
                    else:
                        there_is_a_cli_update_in_folder_var = False

                if not there_is_a_cli_update_in_folder_var:
                    zipinstaller = click.prompt(
                        'Please enter the URL/Path for the CLI update files (tar.gz file)',
                        type=str)
                    if os.path.exists(zipinstaller) or exists(zipinstaller):
                        ctx.invoke(auto_update, zipinstaller)
                        menu = 'autoupdate'
                    else:
                        click.pause('Invalid URL/Local Media. Please try again.')
            else:
                click.pause('The installation is not allowed, please use portal or enable this.')
        except click.Abort:
            menu = 'autoupdate'

    elif char == '2':
        if click.confirm('Are you sure you want to restart? '
                         'All users of the Command Line Interface will be logged out.'
                         'Please ensure you have saved all your changes before committing.'):
            ctx.invoke(kick_off)

    elif char == '3':
        try:
            path = click.prompt('Folder', type=str)
            if click.confirm('You are about to change owner for ' + path + ' Do you want to continue?'):
                ctx.invoke(chown, path)
        except click.Abort:
            menu = 'autoupdate'

    elif char == '4':
        if is_snmp_enabled():
            disable_snmp()
        else:
            enable_snmp()
    elif char == '5':
        if is_snmp_enabled():
            ctx.invoke(edit_snmp_configs)
        else:
            if is_encryption_enabled():
                ctx.invoke(disable_encryption_mode)
            else:
                ctx.invoke(enable_encryption_mode)
    elif char == '6':
        if is_encryption_enabled():
            ctx.invoke(disable_encryption_mode)
        else:
            ctx.invoke(enable_encryption_mode)
    elif char == '7':
        ctx.invoke(enable_snmpv3)
    elif char == 'e':
        if click.confirm('Are you sure, you want to proceed? This can break the system'):
            set_local_aam_installation("True")
    elif char == 'd':
        set_local_aam_installation("False")
    elif char == 'r':
            ctx.invoke(toggle_akkadian_repo_check)
    elif char == 'b':
        menu = 'main'
    return menu, there_is_a_cli_update_in_folder


def render_aam_management_menu():
    is_aam_installation_allowed = is_local_aam_installation_allowed()

    click.clear()
    click.secho('Update Akkadian Appliance Manager', fg='green')
    click.secho('0: Current Appliance Manager Version', fg='green')
    click.secho('1: Update Appliance Manager Using URL/Local Media', fg='green')
    click.secho('2: Restart Appliance Manager', fg='green')
    click.secho('3: Change folder owner', fg='green')
    if is_snmp_enabled():
        click.secho('4: Disable SNMP', fg='green')
        click.secho('5: Edit SNMP', fg='green')

        if is_encryption_enabled():
            click.secho('6: Disable Encryption mode', fg='green')
        else:
            click.secho('6: Enable Encryption mode', fg='green')

        if not is_snmpv3_enable():
            click.secho('7: Enable SNMPv3', fg='green')

    else:
        click.secho('4: Enable SNMP', fg='green')
        if is_encryption_enabled():
            click.secho('5: Disable Encryption mode', fg='green')
        else:
            click.secho('5: Enable Encryption mode', fg='green')
    # click.secho('5: Enable advanced SSL settings in web interface', fg='green')
    if is_aam_installation_allowed:
        click.secho('d: Disable Akkadian Appliance Manager Installation', fg='green')
    else:
        click.secho('e: Enable Akkadian Appliance Manager Installation', fg='green')

    if akkadian_repo_check_is_enabled():
        click.secho('r: Disable Akkadian Repository Connection Check', fg='green')
    else:
        click.secho('r: Enable Akkadian Repository Connection Check', fg='green')

    click.secho('b: Back to Main Menu', fg='red')
    click.secho('You can press \'CTRL+C\' at any time to exit from an action\n'
                'and return to the previous menu.', fg='yellow')
