import subprocess
import time
from urllib.request import urlopen
from subprocess import PIPE, Popen
import os
import signal
import pam

import click
from src.products_installation_handler.products_installation_manager import installed_app_vs2

import configparser
mapper = configparser.RawConfigParser()
mapper.read('mapper.ini')

def exists(path):
    try:
        ret = urlopen(path)
        return ret.code == 200
    except:
        return False


def see_top():
    p = None
    try:
        p = subprocess.call(["sh", mapper.get("GeneralScripts", "serverStatus")], stdout=PIPE, stderr=PIPE)
        click.secho('Calculating server performance status...', fg='green')
        log_file_path = '/home/akkadianuser/logs/top.log'

        try:
            with open(log_file_path, 'r') as f:
                for line in f:
                    line = line.strip().rstrip()
                    click.secho(line, fg='green')

        except FileNotFoundError:
            click.secho('Unable to open the performance log. Please try the Server Performance Monitor option again.', fg='green')
        except Exception as e:
            click.secho('Problems calculating the Server Performance' + e.message, fg='green')

        click.pause('Please, press any key to continue...')

    except KeyboardInterrupt:
        try:
            os.killpg(os.getpgid(p.pid), signal.SIGTERM)
        except OSError:
            pass


def kick_off():
    p = subprocess.Popen(["sh", mapper.get('GeneralScripts', 'logout')], stdout=PIPE,
                         stderr=PIPE)
    for line in p.stdout:
        line = line.decode("utf-8")
        print(line)
    p.wait()

    out, err = p.communicate()
    time.sleep(10)


def chown(path):
    p = subprocess.Popen(["sh", mapper.get('GeneralScripts', 'chown'), path], stdout=PIPE,
                         stderr=PIPE)

    for line in p.stdout:
        line = line.decode("utf-8")
        print(line)
    p.wait()

    out, err = p.communicate()
    time.sleep(10)


def is_encryption_enabled():
    try:
        p = Popen(["sh", mapper.get('GeneralScripts', 'isEncryptionEnabled')], stdout=PIPE, stderr=PIPE)

        for line in p.stdout:
            line = line.decode("utf-8")
            if 'yes' in line:
                return True
            else:
                return False

    except Exception as e:
        print(e)
        return False

    return False


def disable_encryption_mode():
    p = Popen(["sh", mapper.get('GeneralScripts', 'disableEncryption')], stdout=PIPE, stderr=PIPE)
    for line in p.stdout:
        line = line.decode("utf-8")
        print(line)
    p.wait()

    click.pause('Please, press any key to continue...')


def enable_encryption_mode():
    p = Popen(["sh", mapper.get('GeneralScripts', 'enableEncryption')], stdout=PIPE, stderr=PIPE)
    for line in p.stdout:
        line = line.decode("utf-8")
        print(line)
    p.wait()

    click.pause('Please, press any key to continue...')


def installed_application():
    application = installed_app_vs2()

    installed_app = 'unknown'
    if application == 'aco':
        installed_app = application
    elif application == 'pme':
        installed_app = 'pme_cm'
    elif application == 'acm':
        installed_app = 'acm'
    elif application == 'asb':
        installed_app = 'asb'
    return installed_app


def change_password():
    p = subprocess.Popen(["sh", mapper.get('GeneralScripts', 'changePassword')], stdout=PIPE,
                         stderr=PIPE)
    interfaces = []
    for line in p.stdout:
        line = line.decode("utf-8")
        interfaces.append(line)

    return interfaces


def reboot():
    p = subprocess.Popen(["sh", mapper.get('GeneralScripts', 'reboot')], stdout=PIPE,
                         stderr=PIPE)
    for line in p.stdout:
        line = line.decode("utf-8")
        print(line)
    p.wait()


def shutdown():
    p = subprocess.Popen(["sh", mapper.get('GeneralScripts', 'halt')], stdout=PIPE,
                         stderr=PIPE)
    for line in p.stdout:
        line = line.decode("utf-8")
        print(line)
    p.wait()


def crontomcat(day, hour, minute):
    p = subprocess.Popen(["sh", mapper.get('GeneralScripts', 'tomcatCron'), str(day), str(hour), str(minute)],
                         stdout=PIPE,
                         stderr=PIPE)
    for line in p.stdout:
        line = line.decode("utf-8")
        print(line)
    p.wait()


def edit_apache_configs():
    """Open httpd.conf"""
    click.edit(filename=mapper.get('GeneralConfigs', 'apacheFile'))


def edit_php_ini():
    """Edit php.ini file"""
    click.edit(filename=mapper.get('GeneralConfigs', 'phpFile'))


def edit_my_ini():
    """Edit my.ini file"""
    click.edit(filename=mapper.get('GeneralConfigs', 'myFile'))


def generate_non_aco_certificate():
    if click.confirm('This action can modify the behavior of your server, Are you sure you want to continue?'):

        p = Popen(["sh", mapper.get('GeneralScripts', 'generateNonAcoCertificates')], stdout=PIPE, stderr=PIPE)
        for line in p.stdout:
            line = line.decode("utf-8")
            print(line)
        p.wait()

        click.pause('Certificate Generated Correctly, please press any key to continue...')


def run_after_aam_installation_needed_scripts():
    p = Popen(["sh", mapper.get('GeneralScripts', 'runAfterInstallationNeededScripts')], stdout=PIPE, stderr=PIPE)


def show_select_option(char):
    click.secho('\nSelect an option: ', fg='white', blink=True, nl=False)
    char = click.getchar()
    click.echo('')
    return char


def kickoff_this_user():
    p = subprocess.Popen(["sh", mapper.get('GeneralScripts', 'quit')], stdout=PIPE,
                         stderr=PIPE)


def calculate_products_version(cm_version, pme_version):
    pme = subprocess.Popen(["sh", mapper.get('ApplicationScripts', 'pmeVersion')], stdout=PIPE,
                           stderr=PIPE)
    aco_server = subprocess.Popen(["sh", mapper.get('ApplicationScripts', 'acoServerVersion')],
                                  stdout=PIPE, stderr=PIPE)
    aco_web = subprocess.Popen(["sh", mapper.get('ApplicationScripts', 'acoWebVersion')], stdout=PIPE,
                               stderr=PIPE)
    cm = subprocess.Popen(["sh", mapper.get('ApplicationScripts', 'cmVersion')], stdout=PIPE,
                          stderr=PIPE)
    for line in pme.stdout:
        line = line.decode("utf-8")
        pme_version = line
    for line in aco_server.stdout:
        line = line.decode("utf-8")
        aco_server_version = line
    for line in aco_web.stdout:
        line = line.decode("utf-8")
        aco_web_version = line
    for line in cm.stdout:
        line = line.decode("utf-8")
        cm_version = line
    return aco_server_version, cm_version, pme_version


def pme_mysql_stop():
    """
    Stop PME MySQL Service
    """

    click.echo('Stopping...')
    p = Popen(["sh", mapper.get('GeneralScripts', 'pmeMysqlStop')], stdout=PIPE, stderr=PIPE)
    for line in p.stdout:
        line = line.decode("utf-8")
        print(line)
    p.wait()

    if p.returncode != 0:
        click.secho('[FAIL] MySQL Could not be Stopped', fg="red")
    else:
        click.secho('[OK] MySQL Stopped Successfully', fg="yellow")

    time.sleep(3)


def pme_mysql_start():
    """
    Start PME MySQL Service
    """

    click.echo('Starting...')
    p = Popen(["sh", mapper.get('GeneralScripts', 'pmeMysqlStart')], stdout=PIPE, stderr=PIPE)
    for line in p.stdout:
        line = line.decode("utf-8")
        print(line)
    p.wait()

    if p.returncode != 0:
        click.secho('[FAIL] MySQL Could not be Started', fg="red")
    else:
        click.secho('[OK] MySQL Started Successfully', fg="yellow")

    time.sleep(3)


def pme_mysql_restart():
    """
    Restart PME MySQL Service
    """

    click.echo('Restarting...')
    p = Popen(["sh", mapper.get('GeneralScripts', 'pmeMysqlRestart')], stdout=PIPE, stderr=PIPE)
    for line in p.stdout:
        line = line.decode("utf-8")
        print(line)
    p.wait()

    if p.returncode != 0:
        click.secho('[FAIL] MySQL Could not be Restarted', fg="red")
    else:
        click.secho('[OK] MySQL Restarted Successfully', fg="yellow")

    time.sleep(3)


def boolean_evaluator(script_name_in_mapper):
    try:
        p = Popen(["sh", mapper.get('GeneralScripts', script_name_in_mapper)], stdout=PIPE, stderr=PIPE)

        for line in p.stdout:
            line = line.decode("utf-8")
            if 'True' in line:
                return True
            else:
                return False

    except Exception as e:
        print(e)
        return False

    return False


def edit_email_configs():
    """Edit email_configs.ini file"""
    click.edit(filename="/home/akkadianuser/email_configs.ini")


def send_email_test():
    if click.confirm('Are you sure you want to send a test email?'):

        p = Popen(["sh", mapper.get('GeneralScripts', 'sendEmail')], stdout=PIPE, stderr=PIPE)
        for line in p.stdout:
            line = line.decode("utf-8")
            print(line)
        p.wait()

        click.pause('Email sent correctly, please confirm...')


def change_akkadianuser_default_passwords():

    p = pam.pam()
    is_default = p.authenticate('akkadianuser', 'akkadianpassword')
    password = ""

    if is_default:
        click.pause('Your akkadianuser account has the default password, please press any key to change password')
        password = click.prompt('Enter akkadianuser new password', type=str, hide_input=True, confirmation_prompt=True)
        while '\\' in password or '/' in password or '$' in password:
            click.pause('Password cannot have \\ nor / nor $, please press any key to continue')
            password = click.prompt('Enter akkadianuser new password', type=str, hide_input=True, confirmation_prompt=True)

    if password != "":
        click.pause(
            "Your akkadianuser password is about to change, please remember it or store in a secure location to avoid losing access to the Akkadian Appliance Manager.")
        p = Popen(["sh", mapper.get("GeneralScripts", "changeAkkadianuserPass"), password], stdout=PIPE, stderr=PIPE)
        p.wait()
        response = ''
        for line in p.stdout:
            line = line.decode("utf-8")
            response = response + line

    return
