import time
from subprocess import Popen, PIPE
import click
import configparser
mapper = configparser.RawConfigParser()
mapper.read('mapper.ini')


def stop_akkadian_executor():
    click.echo('Stopping...')
    p = Popen(["sh", mapper.get('GeneralScripts', 'executorStop')], stdout=PIPE, stderr=PIPE)
    for line in p.stdout:
        line = line.decode("utf-8")
        print(line)
    p.wait()

    if p.returncode != 0:
        click.secho('[FAIL] Akkadian Executor Could not be Stopped', fg="red")
    else:
        click.secho('[OK] Akkadian Executor Stopped Successfully', fg="yellow")

    time.sleep(3)


def start_akkadian_executor():
    click.echo('Starting...')
    p = Popen(["sh", mapper.get('GeneralScripts', 'executorStart')], stdout=PIPE, stderr=PIPE)
    for line in p.stdout:
        line = line.decode("utf-8")
        print(line)
    p.wait()

    if p.returncode != 0:
        click.secho('[FAIL] Akkadian Executor Could not be Started', fg="red")
    else:
        click.secho('[OK] Akkadian Executor Stopped Started', fg="yellow")

    time.sleep(3)


def status_akkadian_executor():
    p = Popen(["sh", mapper.get('GeneralScripts', 'executorStatus')], stdout=PIPE, stderr=PIPE)
    for line in p.stdout:
        line = line.decode("utf-8")
        print(line)
    p.wait()

    click.pause('Please, press any key to continue...')
