import subprocess
import time
from subprocess import PIPE, Popen

import click

import configparser
mapper = configparser.RawConfigParser()
mapper.read('mapper.ini')


def snmp_start():
    p = subprocess.Popen(["sh", mapper.get('NetworkScripts', 'snmpd_start')], stdout=PIPE,
                         stderr=PIPE)
    for line in p.stdout:
        line = line.decode("utf-8")
        print(line)
    p.wait()


def snmp_stop():
    p = subprocess.Popen(["sh", mapper.get('NetworkScripts', 'snmpd_stop')], stdout=PIPE,
                         stderr=PIPE)
    for line in p.stdout:
        line = line.decode("utf-8")
        print(line)
    p.wait()


def snmp_restart():
    p = subprocess.Popen(["sh", mapper.get('NetworkScripts', 'snmpd_restart')], stdout=PIPE,
                         stderr=PIPE)
    for line in p.stdout:
        line = line.decode("utf-8")
        print(line)
    p.wait()


def enable_snmpv3():
    p = Popen(["sh", mapper.get('NetworkScripts', 'snmpd_stop')], stdout=PIPE, stderr=PIPE)

    for line in p.stdout:
        line = line.decode("utf-8")
        print(line)
    p.wait()

    click.secho('stopping snmp...', fg='green')

    time.sleep(3)

    p = subprocess.call(["net-snmp-create-v3-user"])

    click.secho('starting snmp...', fg='green')
    p = Popen(["sh", mapper.get('GeneralScripts', 'chkconfigSNMPv3')], stdout=PIPE, stderr=PIPE)
    for line in p.stdout:
        line = line.decode("utf-8")
        print(line)
    p.wait()

    click.pause('SNMP V3 enabled...')


def is_snmpv3_enable():
    try:
        p = Popen(["sh", mapper.get('GeneralScripts', 'isSnmpv3Enable')], stdout=PIPE, stderr=PIPE)

        for line in p.stdout:
            line = line.decode("utf-8")
            if 'enable' in line:
                return True
            else:
                return False

    except Exception as e:
        print(e)
        return False

    return False


def enable_snmp():
    try:
        p = Popen(["sh", mapper.get('GeneralScripts', 'enableSnmp')], stdout=PIPE, stderr=PIPE)

        lines = []
        for line in p.stdout:
            line = line.decode("utf-8")
            lines.append(line)

        print("Success")
        return

    except Exception as e:
        print(e)
        return


def disable_snmp():
    try:
        p = Popen(["sh", mapper.get('GeneralScripts', 'disableSnmp')], stdout=PIPE, stderr=PIPE)

        lines = []
        for line in p.stdout:
            line = line.decode("utf-8")
            lines.append(line)

        print("Success")
        return

    except Exception as e:
        print(e)
        return


def is_snmp_enabled():
    try:
        p = Popen(["sh", mapper.get('GeneralScripts', 'isSnmpEnable')], stdout=PIPE, stderr=PIPE)

        for line in p.stdout:
            line = line.decode("utf-8")
            if 'inactive' in line:
                return False
            else:
                return True

    except Exception as e:
        print(e)
        return False


def edit_snmp_configs():
    click.edit(filename=mapper.get('GeneralConfigs', 'snmpFile'))
