#!/bin/bash

#systemctl stop nginx
#systemctl disable nginx


echo "NEW NGINX UPGRADE ------------------------------------------------------------------------" >> /home/akkadianuser/logs/nginx_upgrade.log

isUpgrade="false"
isConectivity="false"
isInstalled="false"

result=$(nginx -v 2>&1 |  sed "s/nginx version:/ /")
result=$(nginx -v 2>&1 |  sed "s/nginx version:/ /" 2>&1 | sed "s/nginx\// /" 2>&1 | xargs)


if [[ ${result} != *"No such file"* && ${result} != *"command not found"* && ${result} != "" ]]; then

	isInstalled="true"

	IFS='.' read -r -a arrayresult <<< "$result"

	if [[ ${#arrayresult[@]} > 0 ]]; then
		isUpgrade="true"
		position=1

		for varrayresult in "${arrayresult[@]}"
		do 
			if [[ $position == 1 ]] && [[ "${varrayresult}" -lt "1" ]]; then		   
				isUpgrade="false"
				break
			fi

			if [[ $position == 2 ]] && [[ "${varrayresult}" -lt "21" ]]; then
				isUpgrade="false"
				break
			fi

			position=$(($position + 1))
		done
	else
	  	isUpgrade="false"
	fi
else
	isInstalled="false"
fi



if ping -q -c 1 -W 1 google.com >/dev/null; then
  isConectivity="true"
else
  isConectivity="false"
fi



echo "isConectivity: ${isConectivity} " >> /home/akkadianuser/logs/nginx_upgrade.log

if [[ $isInstalled == "false" || $isUpgrade == "false" || $1 = "yes" ]]; then


		if [[ $isInstalled == "true"  ]]; then
		result=$(systemctl status nginx);


		if [[ $result == *"Loaded: loaded"* ]]; then

			#Active: inactive (dead)
			#Active: active (running)
			if [[ $result == *"Active: active (running)"* ]]; then
				result=$(systemctl stop nginx);
				result=$(systemctl disable nginx);
			fi
			echo " NGINX----- : Service Stopped" >> /home/akkadianuser/logs/nginx_upgrade.log


			if [ ! -d "/etc/nginx-backup/" ]; then
				mkdir /etc/nginx-backup/
				cp -r /etc/nginx/* /etc/nginx-backup/
				echo " NGINX----- : Backup done" >> /home/akkadianuser/logs/nginx_upgrade.log
			fi

			if [ ! -d "/etc/nginx-html-backup/" ]; then
				mkdir /etc/nginx-html-backup/
				cp -r /usr/share/nginx/html/*  /etc/nginx-html-backup/
			fi

			result=$(yum remove nginx -y)

			echo " NGINX----- : ${result}" >> /home/akkadianuser/logs/nginx_upgrade.log
		else
			echo " NGINX----- : No old nginx version found " >> /home/akkadianuser/logs/nginx_upgrade.log
			result="Complete!"

		fi
		fi


		if [[ $result == *"Complete!"* || $result == *"Listo!"* ]]; then
			echo " NGINX----- : Removed" >> /home/akkadianuser/logs/nginx_upgrade.log


			rm -rf /etc/nginx
                        rm -rf /usr/share/nginx/html/
			rm -rf /var/log/nginx
			rm -rf /var/cache/nginx/
			rm -rf /usr/lib/systemd/system/nginx.service
			rm -rf /usr/lib/systemd/system/nginx-debug.service
			echo " NGINX----- : Directories cleaned" >> /home/akkadianuser/logs/nginx_upgrade.log




			if [[ $isConectivity == "true" ]]; then

				echo " NGINX----- : Installing from repository " >> /home/akkadianuser/logs/nginx_upgrade.log

				if [ ! -f "/etc/yum.repos.d/nginx.repo" ]; then
					cp /home/akkadianuser/scripts/upgrade_nginx/nginx.repo /etc/yum.repos.d/
					echo " NGINX----- : Nginx repo copied" >> /home/akkadianuser/logs/nginx_upgrade.log
				fi

				result=$(yum install nginx -y)

			else
				echo " NGINX----- : Local Installation " >> /home/akkadianuser/logs/nginx_upgrade.log

				if [ -f "/home/akkadianuser/packages/nginx-1.21.4-1.el7.ngx.x86_64.rpm" ]; then
					result=$(yum localinstall /home/akkadianuser/packages/nginx-1.21.4-1.el7.ngx.x86_64.rpm -y)

				else
					echo " NGINX----- : nginx-1.21.4-1.el7.ngx.x86_64.rpm don't exist " >> /home/akkadianuser/logs/nginx_upgrade.log
					result="failed"
				fi
			fi





			if [[ $result == *"Complete!"* || $result == *"Listo!"* ]]; then

				echo " NGINX----- : Installed new version" >> /home/akkadianuser/logs/nginx_upgrade.log

				result=$(systemctl status nginx);


				if [[ $result == *"Loaded: loaded"* ]]; then


					result=$(systemctl stop nginx);


					cp /etc/nginx-backup/nginx.conf /etc/nginx/
					cp /etc/nginx-backup/mime.types /etc/nginx/
					cp -r /etc/nginx-html-backup/* /usr/share/nginx/html/

					result=$(systemctl enable nginx)
					result=$(systemctl start nginx);
					result=$(systemctl status nginx);

					if [[ $result == *"Active: active (running)"* ]]; then
						echo " NGINX----- : Service running" >> /home/akkadianuser/logs/nginx_upgrade.log

					else
						echo " NGINX----- : Service could not started" >> /home/akkadianuser/logs/nginx_upgrade.log
					fi

					result=$(nginx -v 2>&1 |  sed "s/nginx version:/ /")

					echo -e " NGINX----- : was upgraded to ${result}" >> /home/akkadianuser/logs/nginx_upgrade.log
					
				else

					echo " NGINX----- : Service not loaded" >> /home/akkadianuser/logs/nginx_upgrade.log
				fi
			else

				echo " NGINX----- : Could not be installed: ${result}" >> /home/akkadianuser/logs/nginx_upgrade.log

			fi

		else
			echo " NGINX----- : Could not removed" >> /home/akkadianuser/logs/nginx_upgrade.log
		fi




else

	echo -e " NGINX----- : ${result} is already upgraded" >> /home/akkadianuser/logs/nginx_upgrade.log
fi

echo " Nginx Validation done: see /home/akkadianuser/logs/nginx_upgrade.log for more inforation. " >> /home/akkadianuser/logs/aco_installation.log

