#!/bin/bash


current_version=$(dotnet --info | grep Version: | head -n 1 | awk '{print $2}')
new_version=$(/home/akkadianuser/dotnet/dotnet --info | grep Version: | head -n 1 | awk '{print $2}')
acoserver_service_content=$(sudo cat /etc/systemd/system/aco-server.service)

acoserver_service_modified="True"
if [[ "$acoserver_service_content" == *"ExecStart=/usr/bin/dotnet"* ]]; then
  acoserver_service_modified="False"
fi

#Fixing problem on wrong bashrc
if [[ "$new_version" == "5.0.400" && "$acoserver_service_modified" == "True" ]]; then
  is_bashrc_correct=$(sudo cat /home/akkadianuser/.bashrc)
  if [[ "$is_bashrc_correct" != *"#bashrc is correct"* ]]; then
    sudo cp -Rf /home/akkadianuser/scripts/upgrade_dotnet/.bashrc /home/akkadianuser/.bashrc
  fi
  exit 1;
else
  line=$(cat /opt/akkadian/aco-server/wwwroot/version.js)
  aco_version=$(printf $line)
  aco_version_needs_update=$(python /home/akkadianuser/version_comparison.py gt $aco_version "4.9.1")

  if [[ "$current_version" == "2.1.1" && "$aco_version_needs_update" == "True" ]]; then
      sudo mkdir -p /home/akkadianuser/dotnet
      sudo tar zxf /home/akkadianuser/packages/dotnet-sdk-5.0.400-linux-x64.tar.gz -C /home/akkadianuser/dotnet
      sudo cp -Rf /home/akkadianuser/scripts/upgrade_dotnet/.bashrc /home/akkadianuser/.bashrc
      sudo cp -Rf /home/akkadianuser/scripts/upgrade_dotnet/aco-server.service /etc/systemd/system/aco-server.service
      sudo echo " .net 5 installation done" >> /home/akkadianuser/logs/aco_installation.log
      sudo systemctl daemon-reload
  fi
fi
