#!/usr/bin/env bash

product_name=${1#"-"}
product_package=$2

version_after=$(jq '.product.version' /var/www/product_update/manifest.json)
j=$(echo $version_after | tr -d ' \r\n')
j=$(echo $j | tr -d '"')
version_after=$j

build_after=$(jq '.product.build' /var/www/product_update/manifest.json)
j=$(echo $build_after | tr -d ' \r\n')
j=$(echo $j | tr -d '"')
build_after=$j

# If the product is hcs, it recursively calls this script, passing in apm-hcs as the product name, to install apm.
# The apm auu bundle just calls this script with apm as an argument.
if [[ "$product_name" == "apm" || "$product_name" == "apm-hcs" ]]; then
    echo "Installing APM... please wait"
    pme_version_before=$(sh /home/akkadianuser/scripts/get_PME_version.sh)
    echo "Old Version: $pme_version_before"
    d=$(date)

    # Check for updates/APM-ENT zip in our update zip, 0 if present and 1 if not
    apm_update_zip_contains_APM_ENT=$(
        unzip -ql /var/www/product_update/updates/$product_package | grep -qiE '.*APM-ENT.*'
        echo $?
    )
    # Check for updates/Maestro zip in our update zip, 0 if present and 1 if not
    apm_update_zip_contains_Maestro=$(
        unzip -ql /var/www/product_update/updates/$product_package | grep -qiE '.*Maestro.*'
        echo $?
    )
    # If both APM-ENT zip and Maestro zip are present, then unzip the zip in updates, which is named the same as its parent zip
    # (( )) is for numeric comparison
    if ((apm_update_zip_contains_APM_ENT == 0 && apm_update_zip_contains_Maestro == 0)); then
        unzip -o /var/www/product_update/updates/$product_package -d /var/www/product_update/updates/
    fi
    # HCS needs to log its own version to the install history, so skip this step if this install was called by hcs install.
    if [[ "$product_name" == "apm" ]]; then
        echo "apm,$d,$pme_version_before,$version_after-$build_after" >> /var/www/product_update/installation_history.csv
    fi

    echo "sh /home/akkadianuser/scripts/pme_update.sh $pme_version_before /var/www/product_update/updates/${product_package}" >> /var/www/product_update/update.log
    sudo sh /home/akkadianuser/scripts/pme_update.sh $pme_version_before /var/www/product_update/updates/${product_package}

    # Try to install Maestro if apm ent is being installed.
    if [[ "$product_name" != "apm-hcs" ]]; then
        current_maestro_zip_name=$(sudo ls -1 /var/www/product_update/updates/*Maestro*.zip 2> /dev/null | tail -1)
        # If there's no maestro zip present, skip this step.
        if [[ -n $current_maestro_zip_name ]]; then
            current_maestro_zip_name=$(basename "$current_maestro_zip_name")

            echo "$current_maestro_zip_name, now calling -maestro process" >> /var/www/product_update/update.log
            sh /home/akkadianuser/scripts/universal_updater/update_product.sh -maestro $current_maestro_zip_name
        fi
    fi

elif [[ "$product_name" == "acm" ]]; then
    echo "Installing ACM... please wait"
    cm_version_before=$(sh /home/akkadianuser/scripts/get_CM_version.sh)
    d=$(date)
    echo "acm,$d,$cm_version_before,$version_after-$build_after" >> /var/www/product_update/installation_history.csv

    echo "sh /home/akkadianuser/scripts/cm_update.sh /var/www/product_update/updates/${product_package}" >> /var/www/product_update/update.log
    sudo sh /home/akkadianuser/scripts/cm_update.sh /var/www/product_update/updates/${product_package}

elif [[ "$product_name" == "aco" ]]; then
    echo "Installing ACO... please wait"
    cucm_url=$(node /home/akkadianuser/scripts/universal_updater/getCUCMUrlFromConfig.js)

    #TODO: add a new tuple in the jenkins build in order to prompt both versions/builds
    acoserver_version_before=$(sudo sh /home/akkadianuser/scripts/get_ACOSERVER_version.sh)
    acoweb_version_before=$(sudo sh /home/akkadianuser/scripts/get_ACOWEB_version.sh)
    d=$(date)

    sudo sh /home/akkadianuser/scripts/aco_update.sh /var/www/product_update/updates/${product_package} $cucm_url
    echo "aco_server/aco_web,$d,$acoserver_version_before/$acoweb_version_before,$version_after-$build_after" >> /var/www/product_update/installation_history.csv

elif [[ "$product_name" == "orc" || "$product_name" == "asb" || "$product_name" == "maestro" ]]; then

    #the installation_history.csv file is modified inside the laravel_updater script
    echo "Installing $product_name... please wait"

    if [[ "$product_name" == "orc" ]]; then
        check=$(echo "Akkadian Orchestrator" | shasum -a 256) # | awk '{print $1;}')
    elif [[ "$product_name" == "asb" ]]; then
        check=$(echo "Akkadian Site Builder" | shasum -a 256) # | awk '{print $1;}')
    else
        check=$(echo "Akkadian Maestro" | shasum -a 256) # | awk '{print $1;}')
    fi

    echo "sh /home/akkadianuser/scripts/laravel_updater.sh /var/www/product_update/updates/${product_package} 'V33NEup6YuGC2zdte2sRs' '$check' '/var/www/html/$product_name'" >> /var/www/product_update/update.log
    sudo sh /home/akkadianuser/scripts/laravel_updater.sh /var/www/product_update/updates/${product_package} 'V33NEup6YuGC2zdte2sRs' "$check" '/var/www/html/'$product_name

elif [[ "$product_name" == "hcs" ]]; then
    echo "Installing HCS... please wait"
    hcs_version_before=$(sh /home/akkadianuser/scripts/hcs/get_hcs_version.sh)
    d=$(date)
    #manifest.json line: update_product.sh -hcs HCS-5.0.6-5.0.37.2-Update.zip
    #product_package=HCS-5.0.6-5.0.37.2-Update.zip
    unzip -o /var/www/product_update/updates/$product_package -d /var/www/product_update/updates/
    #take APM name
    current_apm_zip_name=$(sudo ls -1 /var/www/product_update/updates/APM*.zip 2> /dev/null | tail -1)
    current_apm_zip_name=$(basename $current_apm_zip_name)
    echo "$current_apm_zip_name, now calling -apm-hcs process" >> /var/www/product_update/update.log
    sh /home/akkadianuser/scripts/universal_updater/update_product.sh -apm-hcs $current_apm_zip_name

    #take orc name
    current_orc_zip_name=$(sudo ls -1 /var/www/product_update/updates/*Orc*.zip 2> /dev/null | tail -1)
    current_orc_zip_name=$(basename $current_orc_zip_name)
    echo "$current_orc_zip_name, now calling -orc process" >> /var/www/product_update/update.log
    sh /home/akkadianuser/scripts/universal_updater/update_product.sh -orc $current_orc_zip_name

    #take asb name
    current_asb_zip_name=$(sudo ls -1 /var/www/product_update/updates/*ASB*.zip 2> /dev/null | tail -1)
    current_asb_zip_name=$(basename $current_asb_zip_name)
    echo "$current_asb_zip_name, now calling -asb process" >> /var/www/product_update/update.log
    sh /home/akkadianuser/scripts/universal_updater/update_product.sh -asb $current_asb_zip_name

    #take maestro name
    current_maestro_zip_name=$(sudo ls -1 /var/www/product_update/updates/*Maestro*.zip 2> /dev/null | tail -1)
    current_maestro_zip_name=$(basename $current_maestro_zip_name)
    echo "$current_maestro_zip_name, now calling -maestro process" >> /var/www/product_update/update.log
    sh /home/akkadianuser/scripts/universal_updater/update_product.sh -maestro $current_maestro_zip_name

    #log update
    echo "hcs,$d,$hcs_version_before,$version_after-$build_after" >> /var/www/product_update/installation_history.csv

    #create hcs version if it does not exist
    if [[ ! -d /var/www/html/hcs ]]; then
      mkdir /var/www/html/hcs
    fi

    #set hcs version
    echo "hcs_version=$version_after" > /var/www/html/hcs/version

elif [[ "$product_name" == "acc" ]]; then
    #run update file
    echo "Installing ACC... please wait"

    #get version details and log update
    acc_version_before=$(sh /home/akkadianuser/scripts/acc/get_acc_version.sh)
    d=$(date)
    echo "acc,$d,$acc_version_before,$version_after-$build_after" >> /var/www/product_update/installation_history.csv

    #get file checksum
    checksum=$(shasum -a 512 "/var/www/product_update/${product_package}")

    #log operationa and run update script
    echo "sh /home/akkadianuser/scripts/acc/acc_update.sh /var/www/product_update/${product_package}" >> /var/www/product_update/update.log

    sudo sh /home/akkadianuser/scripts/acc/acc_update.sh /var/www/product_update/${product_package} 'Tk$5@47u$H&4@$j7oQ4U' "$checksum" '/usr/local/bin/'
fi
