#!/usr/bin/env bash
cli_name=$1
# Set default version to 0.0.0.0 in case we're updating from an old cli version that does not have the get_cli_version
# script.
version_before="0.0.0.0"
# Check if cli version check script exists.
if [[ -f /home/akkadianuser/scripts/get_cli_version.sh ]]; then
  version_before=$(sh /home/akkadianuser/scripts/get_cli_version.sh | awk -F '-' '{print $1}')
fi

sudo sh /home/akkadianuser/scripts/auto_update.sh /var/www/product_update/updates/${cli_name}

# Only write to the installation history log if the CLI was installed successfully.
if [[ $? -eq 0 ]]; then
  version_after=""
  # Check if cli version check script exists.
  if [[ -f /home/akkadianuser/scripts/get_cli_version.sh ]]; then
    version_after=$(sh /home/akkadianuser/scripts/get_cli_version.sh | awk -F '-' '{print $1}')
  fi

  build_after=""
  # Check if cli version check script exists.
  if [[ -f /home/akkadianuser/scripts/get_cli_version.sh ]]; then
    build_after=$(sh /home/akkadianuser/scripts/get_cli_version.sh | awk -F '-' '{print $2}')
  fi

  # Write to the install history if we have a version before and version after that are different.
  if [[ $version_after != "" && $version_before != "" ]]; then
    d=$(date)

    # include or don't include the build depending on whether we have one
    if [[ $build_after != "" ]]; then
      echo "cli,$d,$version_before,$version_after-$build_after" >>/var/www/product_update/installation_history.csv
    else
      echo "cli,$d,$version_before,$version_after" >>/var/www/product_update/installation_history.csv
    fi
  fi
fi
