process.env.NODE_TLS_REJECT_UNAUTHORIZED = '0';
const MongoClient = require('mongodb').MongoClient;
const assert = require('assert');
const axios = require('axios');
const compareVersions = require('compare-versions');

// Connection URL
const url = 'mongodb://mongoDBuser:X46kTVmongo@localhost/AcoServer?authSource=admin';

// Database Name
const dbName = 'AcoServer';

// Use connect method to connect to the server
MongoClient.connect(url, function (err, client) {
    assert.equal(null, err);

    const db = client.db(dbName);


    findGroups(db, function (docs) {
        var minVersion = '10000.0.0.0';
        var minUrl = '';

        var urlsCalls = [];

        for (var i = 0; i < docs.length; i++) {
            var d = docs[i];

            var url = 'https://' + d.axlServer1 + '/cucm-uds/version';

            //resolve(minUrl);

            urlsCalls.push(getVersion(url));
        }

        Promise.all(urlsCalls).then(function (versions) {

            for (var i = 0; i < versions.length; i++) {
                var version = versions[i];

                var comparation = compareVersions(minVersion, version);
                if (comparation > 0) {
                    minVersion = version;
                    minUrl = d.axlServer1;
                }
            }
            console.log(minUrl);
        });

        client.close();
    });


});

const findGroups = function (db, callback) {
    // Get the documents collection
    const collection = db.collection('configurations');
    // Find some documents
    collection.find({}).toArray(function (err, docs) {
        assert.equal(err, null);
        callback(docs);
    });
};

const getVersion = function getVersion(url) {
    // Return new promise
    return new Promise(function (resolve, reject) {

        axios.get(url)
            .then(response => {
                var version = response.data.version;
                resolve(version);

            }).catch(e => {
            console.log(e);
            reject(e);
        });
    });
};
