#!/usr/bin/env bash
echo "Synchronizing Database"
MASTER=$(pcs status | grep RS_VIP_Akkadian | awk -F ' ' '{print $4}')
NODES=$(pcs status | grep Online: | awk -F : '{print $2}')

mysqldump --defaults-extra-file=/home/akkadianuser/.my.cnf -uroot contact_manager > /home/akkadianuser/dbstosync/dbtosync.sql

gpg -d -q --batch --passphrase Akkadian /home/akkadianuser/.sshpassword_pme_cm.gpg > /home/akkadianuser/.sshpass

IFS=$' '
echo "Database Synchronization source: $MASTER"
for j in $NODES
do
        if [[ ( "$j" != "[" ) && ( "$j" != "]" ) && ("$j" != "$MASTER") ]]
        then
                #copying files
                sshpass -f /home/akkadianuser/.sshpass scp -o StrictHostKeyChecking=no /home/akkadianuser/dbstosync/dbtosync.sql root@$j:/home/akkadianuser/dbstosync/dbtosync.sql

                #restore mysql
                sshpass -f /home/akkadianuser/.sshpass ssh -o StrictHostKeyChecking=no root@$j 'mysql --defaults-extra-file=/home/akkadianuser/.my.cnf -u root -e "drop database contact_manager"'
                sshpass -f /home/akkadianuser/.sshpass ssh -o StrictHostKeyChecking=no root@$j 'mysql --defaults-extra-file=/home/akkadianuser/.my.cnf -u root -e "create database contact_manager"'
                sshpass -f /home/akkadianuser/.sshpass ssh -o StrictHostKeyChecking=no root@$j 'mysql --defaults-extra-file=/home/akkadianuser/.my.cnf -u root contact_manager < /home/akkadianuser/dbstosync/dbtosync.sql'

        fi
done

truncate -s 0 /home/akkadianuser/.sshpass
echo "Database Synchronization Completed"
echo "$(date) $(ls -1 | wc -l)" > /home/akkadianuser/sync_end_at_log